import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { _checkIsValidConnection } from "../diagram/connections/isValidConnection";
import { EDGE_TYPES } from "../diagram/edges/EdgeTypes";
import { getDiscreteAutoPositioningEdgeIdMarker, getPointForHandle } from "../diagram/maths/DmnMaths";
import { getRequirementsFromEdge } from "./addConnectedNode";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
export function addEdge({ definitions, drdIndex, sourceNode, targetNode, edge, keepWaypoints, externalModelsByNamespace, dmnElementRefOfDmnEdge, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    const externalTargetAllowed = dmnElementRefOfDmnEdge !== undefined;
    if (!_checkIsValidConnection(sourceNode, targetNode, edge.type, { allowExternalTarget: externalTargetAllowed })) {
        throw new Error(`DMN MUTATION: Invalid structure: (${sourceNode.type}) --${edge.type}--> (${targetNode.type}) `);
    }
    const newEdgeId = generateUuid();
    let existingRequirementOrAssociationId = dmnElementRefOfDmnEdge;
    if (edge.type === EDGE_TYPES.association) {
        (_a = definitions.artifact) !== null && _a !== void 0 ? _a : (definitions.artifact = []);
        const newAssociation = {
            "@_id": newEdgeId,
            "@_associationDirection": "Both",
            sourceRef: { "@_href": `${sourceNode.href}` },
            targetRef: { "@_href": `${targetNode.href}` },
        };
        const removed = removeFirstMatchIfPresent(definitions.artifact, (a) => a.__$$element === "association" && areAssociationsEquivalent(a, newAssociation));
        existingRequirementOrAssociationId = removed === null || removed === void 0 ? void 0 : removed["@_id"];
        (_b = definitions.artifact) === null || _b === void 0 ? void 0 : _b.push({
            __$$element: "association",
            ...newAssociation,
            "@_id": tryKeepingEdgeId(existingRequirementOrAssociationId, newEdgeId),
        });
    }
    else if (!externalTargetAllowed) {
        const requirements = getRequirementsFromEdge(sourceNode, newEdgeId, edge.type);
        const drgElement = definitions.drgElement[targetNode.index];
        if (requirements === null || requirements === void 0 ? void 0 : requirements.informationRequirement) {
            (_c = drgElement.informationRequirement) !== null && _c !== void 0 ? _c : (drgElement.informationRequirement = []);
            const removed = removeFirstMatchIfPresent(drgElement.informationRequirement, (ir) => doesInformationRequirementsPointTo(ir, sourceNode.href));
            existingRequirementOrAssociationId = removed === null || removed === void 0 ? void 0 : removed["@_id"];
            (_d = drgElement.informationRequirement) === null || _d === void 0 ? void 0 : _d.push(...requirements.informationRequirement.map((s) => ({
                ...s,
                "@_id": tryKeepingEdgeId(existingRequirementOrAssociationId, newEdgeId),
            })));
        }
        else if (requirements === null || requirements === void 0 ? void 0 : requirements.knowledgeRequirement) {
            (_e = drgElement.knowledgeRequirement) !== null && _e !== void 0 ? _e : (drgElement.knowledgeRequirement = []);
            const removed = removeFirstMatchIfPresent(drgElement.knowledgeRequirement, (kr) => doesKnowledgeRequirementsPointTo(kr, sourceNode.href));
            existingRequirementOrAssociationId = removed === null || removed === void 0 ? void 0 : removed["@_id"];
            (_f = drgElement.knowledgeRequirement) === null || _f === void 0 ? void 0 : _f.push(...requirements.knowledgeRequirement.map((s) => ({
                ...s,
                "@_id": tryKeepingEdgeId(existingRequirementOrAssociationId, newEdgeId),
            })));
        }
        else if (requirements === null || requirements === void 0 ? void 0 : requirements.authorityRequirement) {
            (_g = drgElement.authorityRequirement) !== null && _g !== void 0 ? _g : (drgElement.authorityRequirement = []);
            const removed = removeFirstMatchIfPresent(drgElement.authorityRequirement, (ar) => doesAuthorityRequirementsPointTo(ar, sourceNode.href));
            existingRequirementOrAssociationId = removed === null || removed === void 0 ? void 0 : removed["@_id"];
            (_h = drgElement.authorityRequirement) === null || _h === void 0 ? void 0 : _h.push(...requirements.authorityRequirement.map((s) => ({
                ...s,
                "@_id": tryKeepingEdgeId(existingRequirementOrAssociationId, newEdgeId),
            })));
        }
    }
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const removedDmnEdge = removeFirstMatchIfPresent(diagramElements, (e) => e.__$$element === "dmndi:DMNEdge" && e["@_dmnElementRef"] === existingRequirementOrAssociationId);
    const newWaypoints = keepWaypoints
        ? [
            getPointForHandle({ bounds: sourceNode.bounds, handle: edge.sourceHandle }),
            ...((_j = removedDmnEdge === null || removedDmnEdge === void 0 ? void 0 : removedDmnEdge["di:waypoint"]) !== null && _j !== void 0 ? _j : []).slice(1, -1),
            getPointForHandle({ bounds: targetNode.bounds, handle: edge.targetHandle }),
        ]
        : [
            getPointForHandle({ bounds: sourceNode.bounds, handle: edge.sourceHandle }),
            getPointForHandle({ bounds: targetNode.bounds, handle: edge.targetHandle }),
        ];
    const newDmnEdge = {
        __$$element: "dmndi:DMNEdge",
        "@_id": withoutDiscreteAutoPosinitioningMarker((_k = removedDmnEdge === null || removedDmnEdge === void 0 ? void 0 : removedDmnEdge["@_id"]) !== null && _k !== void 0 ? _k : generateUuid()) +
            ((_l = edge.autoPositionedEdgeMarker) !== null && _l !== void 0 ? _l : ""),
        "@_dmnElementRef": existingRequirementOrAssociationId !== null && existingRequirementOrAssociationId !== void 0 ? existingRequirementOrAssociationId : newEdgeId,
        "@_sourceElement": sourceNode.shapeId,
        "@_targetElement": targetNode.shapeId,
        "di:waypoint": newWaypoints,
    };
    diagramElements.push(newDmnEdge);
    repopulateInputDataAndDecisionsOnAllDecisionServices({
        definitions,
        externalModelsByNamespace,
    });
    return { newDmnEdge };
}
function doesInformationRequirementsPointTo(a, nodeId) {
    var _a, _b;
    return (((_a = a.requiredInput) === null || _a === void 0 ? void 0 : _a["@_href"]) === `${nodeId}` ||
        ((_b = a.requiredDecision) === null || _b === void 0 ? void 0 : _b["@_href"]) === `${nodeId}`);
}
function doesKnowledgeRequirementsPointTo(a, nodeId) {
    var _a;
    return ((_a = a.requiredKnowledge) === null || _a === void 0 ? void 0 : _a["@_href"]) === `${nodeId}`;
}
function doesAuthorityRequirementsPointTo(a, nodeId) {
    var _a, _b, _c;
    return (((_a = a.requiredInput) === null || _a === void 0 ? void 0 : _a["@_href"]) === `${nodeId}` ||
        ((_b = a.requiredDecision) === null || _b === void 0 ? void 0 : _b["@_href"]) === `${nodeId}` ||
        ((_c = a.requiredAuthority) === null || _c === void 0 ? void 0 : _c["@_href"]) === `${nodeId}`);
}
function areAssociationsEquivalent(a, b) {
    return ((a.sourceRef["@_href"] === b.sourceRef["@_href"] && a.targetRef["@_href"] === b.targetRef["@_href"]) ||
        (a.sourceRef["@_href"] === b.targetRef["@_href"] && a.targetRef["@_href"] === b.sourceRef["@_href"]));
}
function removeFirstMatchIfPresent(arr, predicate) {
    var _a;
    const index = arr.findIndex(predicate);
    const removed = (_a = arr[index]) !== null && _a !== void 0 ? _a : undefined;
    arr.splice(index, index >= 0 ? 1 : 0);
    return removed;
}
function tryKeepingEdgeId(existingEdgeId, newEdgeId) {
    return existingEdgeId !== null && existingEdgeId !== void 0 ? existingEdgeId : newEdgeId;
}
function withoutDiscreteAutoPosinitioningMarker(edgeId) {
    const marker = getDiscreteAutoPositioningEdgeIdMarker(edgeId);
    return marker ? edgeId.replace(`${marker}`, "") : edgeId;
}
//# sourceMappingURL=addEdge.js.map