import { parseXmlHref, xmlHrefToQName } from "@kie-tools/dmn-marshaller/dist/xml";
import { getContainmentRelationship, getDecisionServiceDividerLineLocalY } from "../diagram/maths/DmnMaths";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnDecisionService } from "./repopulateInputDataAndDecisionsOnDecisionService";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
export function addDecisionToDecisionService({ definitions, decisionHref, decisionServiceId, drdIndex, snapGrid, externalModelsByNamespace, }) {
    var _a, _b, _c, _d;
    console.debug(`DMN MUTATION: Adding Decision '${decisionHref}' to Decision Service '${decisionServiceId}'`);
    const href = parseXmlHref(decisionHref);
    if (href.namespace) {
        const externalModel = externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace[href.namespace];
        if (!externalModel) {
            throw new Error(`DMN MUTATION: Namespace '${href.namespace}' not found.`);
        }
        if ((externalModel === null || externalModel === void 0 ? void 0 : externalModel.type) !== "dmn") {
            throw new Error(`DMN MUTATION: External model with namespace ${href.namespace} is not a DMN.`);
        }
        const externalDrgs = externalModel.model.definitions.drgElement;
        const decision = externalDrgs === null || externalDrgs === void 0 ? void 0 : externalDrgs.find((drgElement) => drgElement["@_id"] === href.id);
        if ((decision === null || decision === void 0 ? void 0 : decision.__$$element) !== "decision") {
            throw new Error(`DMN MUTATION: DRG Element with id '${href.id}' is either not a Decision or doesn't exist in the external model '${href.namespace}'`);
        }
    }
    else {
        const decision = (_a = definitions.drgElement) === null || _a === void 0 ? void 0 : _a.find((s) => s["@_id"] === href.id);
        if ((decision === null || decision === void 0 ? void 0 : decision.__$$element) !== "decision") {
            throw new Error(`DMN MUTATION: DRG Element with id '${href.id}' is either not a Decision or doesn't exist.`);
        }
    }
    const decisionService = (_b = definitions.drgElement) === null || _b === void 0 ? void 0 : _b.find((s) => s["@_id"] === decisionServiceId);
    if ((decisionService === null || decisionService === void 0 ? void 0 : decisionService.__$$element) !== "decisionService") {
        throw new Error(`DMN MUTATION: DRG Element with id '${decisionServiceId}' is either not a Decision Service or doesn't exist.`);
    }
    const diagram = addOrGetDrd({ definitions, drdIndex });
    const dmnElementRef = xmlHrefToQName(decisionHref, definitions);
    const decisionShape = diagram.diagramElements.find((s) => s["@_dmnElementRef"] === dmnElementRef && s.__$$element === "dmndi:DMNShape");
    const decisionServiceShape = diagram.diagramElements.find((s) => s["@_dmnElementRef"] === decisionServiceId && s.__$$element === "dmndi:DMNShape");
    const section = getSectionForDecisionInsideDecisionService({ decisionShape, decisionServiceShape, snapGrid });
    if (section === "encapsulated") {
        (_c = decisionService.encapsulatedDecision) !== null && _c !== void 0 ? _c : (decisionService.encapsulatedDecision = []);
        decisionService.encapsulatedDecision.push({ "@_href": `${decisionHref}` });
    }
    else if (section === "output") {
        (_d = decisionService.outputDecision) !== null && _d !== void 0 ? _d : (decisionService.outputDecision = []);
        decisionService.outputDecision.push({ "@_href": `${decisionHref}` });
    }
    else {
        throw new Error(`DMN MUTATION: Invalid section to add decision to: '${section}' `);
    }
    repopulateInputDataAndDecisionsOnDecisionService({ definitions, decisionService, externalModelsByNamespace });
}
export function getSectionForDecisionInsideDecisionService({ decisionShape, decisionServiceShape, snapGrid, }) {
    if (!(decisionShape === null || decisionShape === void 0 ? void 0 : decisionShape["dc:Bounds"]) || !(decisionServiceShape === null || decisionServiceShape === void 0 ? void 0 : decisionServiceShape["dc:Bounds"])) {
        throw new Error(`DMN MUTATION: Can't determine Decision Service section for Decision '${decisionShape["@_dmnElementRef"]}' because it doens't have a DMNShape.`);
    }
    const contaimentRelationship = getContainmentRelationship({
        bounds: decisionShape["dc:Bounds"],
        container: decisionServiceShape["dc:Bounds"],
        divingLineLocalY: getDecisionServiceDividerLineLocalY(decisionServiceShape),
        snapGrid,
        isAlternativeInputDataShape: false,
        containerMinSizes: MIN_NODE_SIZES[NODE_TYPES.decisionService],
        boundsMinSizes: MIN_NODE_SIZES[NODE_TYPES.decision],
    });
    if (!contaimentRelationship.isInside) {
        throw new Error(`DMN MUTATION: Decision '${decisionShape["@_dmnElementRef"]}' can't be added to Decision Service '${decisionServiceShape["@_dmnElementRef"]}' because its shape is not visually contained by the Decision Service's shape.`);
    }
    return contaimentRelationship.section === "upper" ? "output" : "encapsulated";
}
//# sourceMappingURL=addDecisionToDecisionService.js.map