import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { drag } from "d3-drag";
import { select } from "d3-selection";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef } from "react";
import * as RF from "reactflow";
import { addTopLevelItemDefinition } from "../../mutations/addTopLevelItemDefinition";
import { renameGroupNode, updateTextAnnotation } from "../../mutations/renameNode";
import { updateDecisionServiceDividerLine } from "../../mutations/updateDecisionServiceDividerLine";
import { DmnEditorTab } from "../../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { snapShapeDimensions } from "../SnapGrid";
import { PositionalNodeHandles } from "../connections/PositionalNodeHandles";
import { containment, outgoingStructure } from "../connections/graphStructure";
import { EDGE_TYPES } from "../edges/EdgeTypes";
import { getContainmentRelationship, getDecisionServiceDividerLineLocalY } from "../maths/DmnMaths";
import { useIsHovered } from "../useIsHovered";
import { DataTypeNodePanel } from "./DataTypeNodePanel";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "./DefaultSizes";
import { EditExpressionNodePanel } from "./EditExpressionNodePanel";
import { EditableNodeLabel, useEditableNodeLabel } from "./EditableNodeLabel";
import { InfoNodePanel } from "./InfoNodePanel";
import { getNodeLabelPosition, useNodeStyle } from "./NodeStyle";
import { AlternativeInputDataNodeSvg, BkmNodeSvg, DecisionNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, InputDataNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, UnknownNodeSvg, } from "./NodeSvgs";
import { NODE_TYPES } from "./NodeTypes";
import { OutgoingStuffNodePanel } from "./OutgoingStuffNodePanel";
import { propsHaveSameValuesDeep } from "../memoization/memoization";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
import { NODE_LAYERS } from "../../store/computed/computeDiagramData";
import { useSettings } from "../../settings/DmnEditorSettingsContext";
import { useDmnEditor } from "../../DmnEditorContext";
import { useRefactor } from "../../refactor/RefactorConfirmationDialog";
export const InputDataNode = React.memo(({ data: { dmnObject: inputData, shape, index, dmnObjectQName, dmnObjectNamespace }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c;
    const ref = useRef(null);
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const isAlternativeInputDataShape = useDmnEditorStore((s) => s.computed(s).isAlternativeInputDataShape());
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
        isAlternativeInputDataShape,
    });
    const { externalModelsByNamespace } = useExternalModels();
    const identifierId = useMemo(() => inputData["@_id"], [inputData]);
    const oldName = useMemo(() => { var _a; return (_a = inputData["@_label"]) !== null && _a !== void 0 ? _a : inputData["@_name"]; }, [inputData]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({ index, identifierId, oldName });
    const onTypeRefChange = useCallback((newTypeRef) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": inputData["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
        });
    }, [dmnEditorStoreApi, index, inputData]);
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const onCreateDataType = useDataTypeCreationCallbackForNodes(index, inputData["@_name"]);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    const isCollection = useDmnEditorStore((s) => {
        var _a, _b, _c, _d, _e, _f;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = s
            .computed(s)
            .getDataTypes(externalModelsByNamespace);
        return ((_f = (_e = (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = inputData.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition) === null || _e === void 0 ? void 0 : _e["@_isCollection"]) !== null && _f !== void 0 ? _f : false);
    });
    const [alternativeEditableNodeHeight, setAlternativeEditableNodeHeight] = React.useState(0);
    const alternativeSvgStyle = useMemo(() => {
        return isAlternativeInputDataShape
            ? {
                display: "flex",
                flexDirection: "column",
                outline: "none",
                "--selected-alternative-input-data-node-shape--height": `${nodeDimensions.height + 20 + (isEditingLabel ? 20 : alternativeEditableNodeHeight !== null && alternativeEditableNodeHeight !== void 0 ? alternativeEditableNodeHeight : 0)}px`,
            }
            : undefined;
    }, [isAlternativeInputDataShape, nodeDimensions, isEditingLabel, alternativeEditableNodeHeight]);
    const selectedAlternativeClass = useMemo(() => (isAlternativeInputDataShape && selected ? "kie-dmn-editor--selected-alternative-input-data-node" : ""), [isAlternativeInputDataShape, selected]);
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx("svg", { className: `kie-dmn-editor--node-shape ${className} ${isAlternativeInputDataShape ? "alternative" : ""} ${selected ? "selected" : ""}`, children: isAlternativeInputDataShape ? (_jsx(AlternativeInputDataNodeSvg, { isCollection: isCollection, ...nodeDimensions, x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, isIcon: false })) : (_jsx(InputDataNodeSvg, { isCollection: isCollection, ...nodeDimensions, x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor })) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, style: alternativeSvgStyle, className: `kie-dmn-editor--input-data-node ${className} ${selectedAlternativeClass}`, ref: ref, tabIndex: -1, "data-nodehref": id, "data-nodelabel": inputData["@_name"], children: [_jsxs("div", { className: `kie-dmn-editor--node `, children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.inputData].nodes, edgeTypes: outgoingStructure[NODE_TYPES.inputData].edges }), !isAlternativeInputDataShape && (_jsx(EditableNodeLabel, { id: id, namedElement: inputData, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({
                                    nodeType: type,
                                    isAlternativeInputDataShape,
                                }), value: (_a = inputData["@_label"]) !== null && _a !== void 0 ? _a : inputData["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties })), shouldActLikeHovered && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_b = inputData["@_label"]) !== null && _b !== void 0 ? _b : inputData["@_name"], nodeShapeIndex: shape.index, isAlternativeInputDataShape: isAlternativeInputDataShape })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, isReadOnly: settings.isReadOnly, variable: inputData.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onCreate: onCreateDataType, onChange: onTypeRefChange })] }), isAlternativeInputDataShape && _jsx("div", { style: { height: nodeDimensions.height, flexShrink: 0 } }), isAlternativeInputDataShape && (_jsx(EditableNodeLabel, { id: id, namedElement: inputData, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type, isAlternativeInputDataShape }), value: (_c = inputData["@_label"]) !== null && _c !== void 0 ? _c : inputData["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: { ...fontCssProperties, zIndex: 2000 }, setLabelHeight: setAlternativeEditableNodeHeight }))] })] }));
}, propsHaveSameValuesDeep);
export const DecisionNode = React.memo(({ data: { parentRfNode, dmnObject: decision, shape, index, dmnObjectQName, dmnObjectNamespace, hasHiddenRequirements, }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c;
    const ref = useRef(null);
    const isExternal = !!dmnObjectQName.prefix;
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const { externalModelsByNamespace } = useExternalModels();
    const identifierId = useMemo(() => decision["@_id"], [decision]);
    const oldName = useMemo(() => { var _a; return (_a = decision["@_label"]) !== null && _a !== void 0 ? _a : decision["@_name"]; }, [decision]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({ index, identifierId, oldName });
    const onTypeRefChange = useCallback((newTypeRef) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decision["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
            if (drgElement.expression) {
                drgElement.expression["@_typeRef"] = newTypeRef;
            }
        });
    }, [decision, dmnEditorStoreApi, index]);
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const onCreateDataType = useDataTypeCreationCallbackForNodes(index, decision["@_name"]);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    const isCollection = useDmnEditorStore((s) => {
        var _a, _b, _c, _d, _e, _f;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = s
            .computed(s)
            .getDataTypes(externalModelsByNamespace);
        return ((_f = (_e = (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = decision.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition) === null || _e === void 0 ? void 0 : _e["@_isCollection"]) !== null && _f !== void 0 ? _f : false);
    });
    const isEvaluationHighlightsEnabled = useDmnEditorStore((s) => s.diagram.overlays.enableEvaluationHighlights);
    const { evaluationResultsByNodeId } = useDmnEditor();
    const evaluationResultsClassName = useMemo(() => {
        var _a, _b;
        return isEvaluationHighlightsEnabled &&
            ((_a = evaluationResultsByNodeId === null || evaluationResultsByNodeId === void 0 ? void 0 : evaluationResultsByNodeId.get(decision["@_id"])) === null || _a === void 0 ? void 0 : _a.evaluationResult) !== undefined
            ? `kie-dmn-editor--decision-node--evaluation-status-${(_b = evaluationResultsByNodeId === null || evaluationResultsByNodeId === void 0 ? void 0 : evaluationResultsByNodeId.get(decision["@_id"])) === null || _b === void 0 ? void 0 : _b.evaluationResult}`
            : "";
    }, [decision, evaluationResultsByNodeId, isEvaluationHighlightsEnabled]);
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(DecisionNodeSvg, { isCollection: isCollection, ...nodeDimensions, x: 0, y: 0, strokeWidth: parentRfNode ? 3 : shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { ref: ref, className: `kie-dmn-editor--node kie-dmn-editor--decision-node ${className} ${evaluationResultsClassName}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": decision["@_name"], children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), !isExternal && (_jsx(EditExpressionNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, id: decision["@_id"] })), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.decision].nodes, edgeTypes: outgoingStructure[NODE_TYPES.decision].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: decision, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type }), value: (_a = decision["@_label"]) !== null && _a !== void 0 ? _a : decision["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_c = (_b = decision["@_label"]) !== null && _b !== void 0 ? _b : decision["@_name"]) !== null && _c !== void 0 ? _c : "", nodeShapeIndex: shape.index })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, isReadOnly: settings.isReadOnly, variable: decision.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onChange: onTypeRefChange, onCreate: onCreateDataType })] })] }));
}, propsHaveSameValuesDeep);
export const BkmNode = React.memo(({ data: { dmnObject: bkm, shape, index, dmnObjectQName, dmnObjectNamespace, hasHiddenRequirements }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c;
    const ref = useRef(null);
    const isExternal = !!dmnObjectQName.prefix;
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({ nodeType: type, snapGrid, shape });
    const identifierId = useMemo(() => bkm["@_id"], [bkm]);
    const oldName = useMemo(() => { var _a; return (_a = bkm["@_label"]) !== null && _a !== void 0 ? _a : bkm["@_name"]; }, [bkm]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({ index, identifierId, oldName });
    const onTypeRefChange = useCallback((newTypeRef) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": bkm["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
            if (drgElement.encapsulatedLogic) {
                drgElement.encapsulatedLogic["@_typeRef"] = newTypeRef;
            }
        });
    }, [bkm, dmnEditorStoreApi, index]);
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const onCreateDataType = useDataTypeCreationCallbackForNodes(index, bkm["@_name"]);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(BkmNodeSvg, { ...nodeDimensions, x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { ref: ref, className: `kie-dmn-editor--node kie-dmn-editor--bkm-node ${className}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": bkm["@_name"], children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), !isExternal && _jsx(EditExpressionNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, id: bkm["@_id"] }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.bkm].nodes, edgeTypes: outgoingStructure[NODE_TYPES.bkm].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: bkm, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type }), value: (_a = bkm["@_label"]) !== null && _a !== void 0 ? _a : bkm["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_c = (_b = bkm["@_label"]) !== null && _b !== void 0 ? _b : bkm["@_name"]) !== null && _c !== void 0 ? _c : "", nodeShapeIndex: shape.index })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, isReadOnly: settings.isReadOnly, variable: bkm.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onChange: onTypeRefChange, onCreate: onCreateDataType })] })] }));
}, propsHaveSameValuesDeep);
export const KnowledgeSourceNode = React.memo(({ data: { dmnObject: knowledgeSource, shape, index, dmnObjectQName, hasHiddenRequirements }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c;
    const ref = useRef(null);
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const identifierId = useMemo(() => knowledgeSource["@_id"], [knowledgeSource]);
    const oldName = useMemo(() => { var _a; return (_a = knowledgeSource["@_label"]) !== null && _a !== void 0 ? _a : knowledgeSource["@_name"]; }, [knowledgeSource]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({ index, identifierId, oldName });
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(KnowledgeSourceNodeSvg, { ...nodeDimensions, x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { ref: ref, className: `kie-dmn-editor--node kie-dmn-editor--knowledge-source-node ${className}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": knowledgeSource["@_name"], children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.knowledgeSource].nodes, edgeTypes: outgoingStructure[NODE_TYPES.knowledgeSource].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: knowledgeSource, namedElementQName: dmnObjectQName, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_a = knowledgeSource["@_label"]) !== null && _a !== void 0 ? _a : knowledgeSource["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_c = (_b = knowledgeSource["@_label"]) !== null && _b !== void 0 ? _b : knowledgeSource["@_name"]) !== null && _c !== void 0 ? _c : "", nodeShapeIndex: shape.index }))] })] }));
}, propsHaveSameValuesDeep);
export const TextAnnotationNode = React.memo(({ data: { dmnObject: textAnnotation, shape, index }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c, _d, _e, _f, _g;
    const ref = useRef(null);
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const setText = useCallback((newText) => {
        dmnEditorStoreApi.setState((state) => {
            updateTextAnnotation({ definitions: state.dmn.model.definitions, newText, index });
        });
    }, [dmnEditorStoreApi, index]);
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    return (_jsxs(_Fragment, { children: [_jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(TextAnnotationNodeSvg, { ...nodeDimensions, x: 0, y: 0, strokeColor: shapeStyle.strokeColor, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { ref: ref, className: `kie-dmn-editor--node kie-dmn-editor--text-annotation-node ${className}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": (_a = textAnnotation["@_label"]) !== null && _a !== void 0 ? _a : (_b = textAnnotation.text) === null || _b === void 0 ? void 0 : _b.__$$text, children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.textAnnotation].nodes, edgeTypes: outgoingStructure[NODE_TYPES.textAnnotation].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_c = textAnnotation["@_label"]) !== null && _c !== void 0 ? _c : (_d = textAnnotation.text) === null || _d === void 0 ? void 0 : _d.__$$text, onChange: setText, skipValidation: true, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_g = (_e = textAnnotation["@_label"]) !== null && _e !== void 0 ? _e : (_f = textAnnotation.text) === null || _f === void 0 ? void 0 : _f.__$$text) !== null && _g !== void 0 ? _g : "", nodeShapeIndex: shape.index }))] })] }));
}, propsHaveSameValuesDeep);
export const DecisionServiceNode = React.memo(({ data: { dmnObject: decisionService, shape, index, dmnObjectQName, dmnObjectNamespace }, selected, dragging, zIndex, type, id, }) => {
    var _a, _b, _c, _d;
    const ref = useRef(null);
    const { externalModelsByNamespace } = useExternalModels();
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const isDropTarget = useDmnEditorStore((s) => { var _a; return ((_a = s.diagram.dropTargetNode) === null || _a === void 0 ? void 0 : _a.id) === id; });
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const identifierId = useMemo(() => decisionService["@_id"], [decisionService]);
    const oldName = useMemo(() => { var _a; return (_a = decisionService["@_label"]) !== null && _a !== void 0 ? _a : decisionService["@_name"]; }, [decisionService]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog } = useRefactor({ index, identifierId, oldName });
    useEffect(() => {
        const onDoubleClick = () => {
            dmnEditorStoreApi.setState((state) => {
                var _a, _b;
                state.diagram._selectedNodes = [
                    id,
                    ...((_a = decisionService.outputDecision) !== null && _a !== void 0 ? _a : []).map((od) => od["@_href"]),
                    ...((_b = decisionService.encapsulatedDecision) !== null && _b !== void 0 ? _b : []).map((ed) => ed["@_href"]),
                ];
            });
        };
        const r = ref.current;
        r === null || r === void 0 ? void 0 : r.addEventListener("dblclick", onDoubleClick);
        return () => {
            r === null || r === void 0 ? void 0 : r.removeEventListener("dblclick", onDoubleClick);
        };
    }, [decisionService.encapsulatedDecision, decisionService.outputDecision, dmnEditorStoreApi, id]);
    const onTypeRefChange = useCallback((newTypeRef) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decisionService["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
        });
    }, [decisionService, dmnEditorStoreApi, index]);
    const getAllFeelVariableUniqueNames = useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []);
    const dividerLineRef = useRef(null);
    const isCollapsed = (_a = shape["@_isCollapsed"]) !== null && _a !== void 0 ? _a : false;
    const onCreateDataType = useDataTypeCreationCallbackForNodes(index, decisionService["@_name"]);
    useEffect(() => {
        if (!dividerLineRef.current) {
            return;
        }
        const selection = select(dividerLineRef.current);
        const dragHandler = drag()
            .on("start", () => {
            dmnEditorStoreApi.setState((state) => state.dispatch(state).diagram.setDividerLineStatus(id, { moving: true }));
        })
            .on("drag", (e) => {
            dmnEditorStoreApi.setState((state) => {
                updateDecisionServiceDividerLine({
                    definitions: state.dmn.model.definitions,
                    drdIndex: state.computed(state).getDrdIndex(),
                    __readonly_dmnShapesByHref: state.computed(state).indexedDrd().dmnShapesByHref,
                    drgElementIndex: index,
                    __readonly_dmnObjectNamespace: dmnObjectNamespace,
                    __readonly_externalDmnsIndex: state
                        .computed(state)
                        .getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns,
                    shapeIndex: shape.index,
                    localYPosition: e.y,
                    snapGrid: state.diagram.snapGrid,
                });
            });
        })
            .on("end", (e) => {
            dmnEditorStoreApi.setState((state) => state.dispatch(state).diagram.setDividerLineStatus(id, { moving: false }));
        });
        selection.call(dragHandler);
        return () => {
            selection.on(".drag", null);
        };
    }, [decisionService, dmnEditorStoreApi, dmnObjectNamespace, externalModelsByNamespace, id, index, shape.index]);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(DecisionServiceNodeSvg, { dividerLineRef: dividerLineRef, ref: ref, ...nodeDimensions, x: 0, y: 0, strokeWidth: 3, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, isReadOnly: settings.isReadOnly, isCollapsed: isCollapsed, showSectionLabels: isDropTarget, dividerLineLocalY: getDecisionServiceDividerLineLocalY(shape) }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { className: `kie-dmn-editor--node kie-dmn-editor--decision-service-node ${className}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": decisionService["@_name"], children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && selected && !dragging }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && selected && !dragging, nodeTypes: outgoingStructure[NODE_TYPES.decisionService].nodes, edgeTypes: outgoingStructure[NODE_TYPES.decisionService].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: decisionService, namedElementQName: dmnObjectQName, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_b = decisionService["@_label"]) !== null && _b !== void 0 ? _b : decisionService["@_name"], onChange: setNewIdentifierNameCandidate, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), selected && !dragging && !settings.isReadOnly && !isCollapsed && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_d = (_c = decisionService["@_label"]) !== null && _c !== void 0 ? _c : decisionService["@_name"]) !== null && _d !== void 0 ? _d : "", nodeShapeIndex: shape.index })), isCollapsed && _jsx("div", { className: "kie-dmn-editor--decision-service-collapsed-button", children: "+" }), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && selected && !dragging, isReadOnly: settings.isReadOnly, variable: decisionService.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onCreate: onCreateDataType, onChange: onTypeRefChange })] })] }));
}, propsHaveSameValuesDeep);
export const GroupNode = React.memo(({ data: { dmnObject: group, shape, index }, selected, dragging, type, id, }) => {
    var _a, _b, _c;
    const ref = useRef(null);
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const enableCustomNodeStyles = useDmnEditorStore((s) => s.diagram.overlays.enableCustomNodeStyles);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const reactFlow = RF.useReactFlow();
    const { isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter } = useEditableNodeLabel(id);
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const setName = useCallback((newName) => {
        dmnEditorStoreApi.setState((state) => {
            renameGroupNode({ definitions: state.dmn.model.definitions, newName, index });
        });
    }, [dmnEditorStoreApi, index]);
    useEffect(() => {
        const onDoubleClick = () => {
            dmnEditorStoreApi.setState((state) => {
                state.diagram._selectedNodes = reactFlow.getNodes().flatMap((n) => getContainmentRelationship({
                    bounds: n.data.shape["dc:Bounds"],
                    container: shape["dc:Bounds"],
                    snapGrid: state.diagram.snapGrid,
                    isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                    containerMinSizes: MIN_NODE_SIZES[NODE_TYPES.group],
                    boundsMinSizes: MIN_NODE_SIZES[n.type],
                }).isInside
                    ? [n.id]
                    : []);
            });
        };
        const r = ref.current;
        r === null || r === void 0 ? void 0 : r.addEventListener("dblclick", onDoubleClick);
        return () => {
            r === null || r === void 0 ? void 0 : r.removeEventListener("dblclick", onDoubleClick);
        };
    }, [dmnEditorStoreApi, reactFlow, shape]);
    const { fontCssProperties, shapeStyle } = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    });
    return (_jsxs(_Fragment, { children: [_jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(GroupNodeSvg, { ref: ref, ...nodeDimensions, x: 0, y: 0, strokeWidth: 3, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor }) }), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", { className: `kie-dmn-editor--node kie-dmn-editor--group-node ${className}`, tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": group["@_name"], children: [_jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !settings.isReadOnly && !isTargeted && selected && !dragging, nodeTypes: outgoingStructure[NODE_TYPES.group].nodes, edgeTypes: outgoingStructure[NODE_TYPES.group].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_a = group["@_label"]) !== null && _a !== void 0 ? _a : group["@_name"], onChange: setName, skipValidation: true, onGetAllUniqueNames: useCallback(() => new Map(), []), shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), selected && !dragging && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_c = (_b = group["@_label"]) !== null && _b !== void 0 ? _b : group["@_name"]) !== null && _c !== void 0 ? _c : "", nodeShapeIndex: shape.index }))] })] }));
}, propsHaveSameValuesDeep);
export const UnknownNode = React.memo(({ data: { shape }, selected, dragging, type, id }) => {
    const ref = useRef(null);
    const snapGrid = useDmnEditorStore((s) => s.diagram.snapGrid);
    const isHovered = useIsHovered(ref);
    const isResizing = useNodeResizing(id);
    const shouldActLikeHovered = useDmnEditorStore((s) => (isHovered || isResizing) && s.diagram.draggingNodes.length === 0);
    const { isTargeted, isValidConnectionTarget } = useConnectionTargetStatus(id, shouldActLikeHovered);
    const className = useNodeClassName(isValidConnectionTarget, id);
    const nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid,
        shape,
    });
    const settings = useSettings();
    return (_jsxs(_Fragment, { children: [_jsx("svg", { className: `kie-dmn-editor--node-shape ${className}`, children: _jsx(UnknownNodeSvg, { ...nodeDimensions, x: 0, y: 0 }) }), _jsx(RF.Handle, { id: "unknown", type: "source", style: { opacity: 0 }, position: RF.Position.Top }, "unknown"), _jsxs("div", { ref: ref, className: `kie-dmn-editor--node kie-dmn-editor--unknown-node ${className}`, tabIndex: -1, "data-nodehref": id, children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: false, setEditing: () => { }, value: `? `, onChange: () => { }, skipValidation: false, onGetAllUniqueNames: useCallback(() => new Map(), []), shouldCommitOnBlur: true }), selected && !dragging && !settings.isReadOnly && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: "unknown", nodeShapeIndex: shape.index }))] })] }));
}, propsHaveSameValuesDeep);
export function EmptyLabel() {
    return (_jsxs("span", { style: { fontFamily: "serif" }, children: [_jsx("i", { style: { opacity: 0.8 }, children: `<Empty>` }), _jsx("br", {}), _jsx("i", { style: { opacity: 0.5, fontSize: "0.8em", lineHeight: "0.8em" }, children: `Double-click to name` })] }));
}
const resizerControlStyle = {
    background: "transparent",
    border: "none",
};
export function NodeResizerHandle(props) {
    const minSize = props.nodeType === NODE_TYPES.inputData
        ? MIN_NODE_SIZES[props.nodeType]({
            snapGrid: props.snapGrid,
            isAlternativeInputDataShape: props.isAlternativeInputDataShape,
        })
        : MIN_NODE_SIZES[props.nodeType]({
            snapGrid: props.snapGrid,
        });
    return (_jsx(RF.NodeResizeControl, { style: resizerControlStyle, minWidth: minSize["@_width"], minHeight: minSize["@_height"], children: _jsx("div", { "data-testid": `kie-tools--dmn-editor--${props.nodeName}-resize-handle`, style: {
                position: "absolute",
                top: "-10px",
                left: "-10px",
                width: "12px",
                height: "12px",
                backgroundColor: "black",
                clipPath: "polygon(0 100%, 100% 100%, 100% 0)",
            } }) }));
}
function useNodeResizing(id) {
    return RF.useStore((s) => { var _a, _b; return (_b = (_a = s.nodeInternals.get(id)) === null || _a === void 0 ? void 0 : _a.resizing) !== null && _b !== void 0 ? _b : false; });
}
function useNodeDimensions(args) {
    const { nodeType, snapGrid, shape } = args;
    const isAlternativeInputDataShape = nodeType === NODE_TYPES.inputData ? args.isAlternativeInputDataShape : false;
    return useMemo(() => {
        if (nodeType === NODE_TYPES.decisionService && shape["@_isCollapsed"]) {
            return DECISION_SERVICE_COLLAPSED_DIMENSIONS;
        }
        const minSizes = nodeType === NODE_TYPES.inputData
            ? MIN_NODE_SIZES[nodeType]({
                snapGrid,
                isAlternativeInputDataShape,
            })
            : MIN_NODE_SIZES[nodeType]({
                snapGrid,
            });
        return {
            width: snapShapeDimensions(snapGrid, shape, minSizes).width,
            height: snapShapeDimensions(snapGrid, shape, minSizes).height,
        };
    }, [isAlternativeInputDataShape, shape, snapGrid, nodeType]);
}
function useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditing) {
    useLayoutEffect(() => {
        const r = ref.current;
        if (selected && !isEditing) {
            r === null || r === void 0 ? void 0 : r.focus();
        }
        if (r) {
            r.parentElement.style.zIndex = `${shouldActLikeHovered || dragging ? zIndex + NODE_LAYERS.NESTED_NODES + 1 : zIndex}`;
        }
    }, [dragging, shouldActLikeHovered, ref, zIndex, selected, isEditing]);
}
export function useConnection(nodeId) {
    const connectionNodeId = RF.useStore((s) => s.connectionNodeId);
    const connectionHandleType = RF.useStore((s) => s.connectionHandleType);
    const source = connectionNodeId;
    const target = nodeId;
    const edgeIdBeingUpdated = useDmnEditorStore((s) => s.diagram.edgeIdBeingUpdated);
    const sourceHandle = RF.useStore((s) => { var _a, _b, _c; return (_c = (_a = s.connectionHandleId) !== null && _a !== void 0 ? _a : (_b = s.edges.find((e) => e.id === edgeIdBeingUpdated)) === null || _b === void 0 ? void 0 : _b.type) !== null && _c !== void 0 ? _c : null; });
    const connection = useMemo(() => ({
        source: connectionHandleType === "source" ? source : target,
        target: connectionHandleType === "source" ? target : source,
        sourceHandle,
        targetHandle: null,
    }), [connectionHandleType, source, sourceHandle, target]);
    return connection;
}
export function useConnectionTargetStatus(nodeId, shouldActLikeHovered) {
    const isTargeted = RF.useStore((s) => !!s.connectionNodeId && s.connectionNodeId !== nodeId && shouldActLikeHovered);
    const connection = useConnection(nodeId);
    const isValidConnectionTarget = RF.useStore((s) => { var _a, _b; return (_b = (_a = s.isValidConnection) === null || _a === void 0 ? void 0 : _a.call(s, connection)) !== null && _b !== void 0 ? _b : false; });
    return useMemo(() => ({
        isTargeted,
        isValidConnectionTarget,
    }), [isTargeted, isValidConnectionTarget]);
}
export function useNodeClassName(isValidConnectionTarget, nodeId) {
    const isDropTarget = useDmnEditorStore((s) => { var _a, _b; return ((_a = s.diagram.dropTargetNode) === null || _a === void 0 ? void 0 : _a.id) === nodeId && containment.get((_b = s.diagram.dropTargetNode) === null || _b === void 0 ? void 0 : _b.type); });
    const { externalModelsByNamespace } = useExternalModels();
    const isDropTargetNodeValidForSelection = useDmnEditorStore((s) => s.computed(s).isDropTargetNodeValidForSelection(externalModelsByNamespace));
    const isConnectionNodeId = RF.useStore((s) => s.connectionNodeId === nodeId);
    const connection = useConnection(nodeId);
    const isEdgeConnection = !!Object.values(EDGE_TYPES).find((s) => s === connection.sourceHandle);
    const isNodeConnection = !!Object.values(NODE_TYPES).find((s) => s === connection.sourceHandle);
    if (isNodeConnection && !isConnectionNodeId) {
        return "dimmed";
    }
    if (isEdgeConnection && (!isValidConnectionTarget || isConnectionNodeId)) {
        return "dimmed";
    }
    if (isDropTarget) {
        return isDropTargetNodeValidForSelection ? "drop-target" : "drop-target-invalid";
    }
    return "normal";
}
export function useDataTypeCreationCallbackForNodes(index, drgElementName) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    return useCallback((newDataTypeName) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": drgElementName });
            drgElement.variable["@_typeRef"] = newDataTypeName;
            const newItemDefinition = addTopLevelItemDefinition({
                definitions: state.dmn.model.definitions,
                partial: { "@_name": newDataTypeName, typeRef: undefined },
            });
            state.dataTypesEditor.activeItemDefinitionId = newItemDefinition["@_id"];
            state.navigation.tab = DmnEditorTab.DATA_TYPES;
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [dmnEditorStoreApi, drgElementName, index]);
}
//# sourceMappingURL=Nodes.js.map