import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useState } from "react";
import { DropdownItem } from "@patternfly/react-core/dist/js/components/Dropdown";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner";
import PlusIcon from "@patternfly/react-icons/dist/js/icons/plus-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { ImportJavaClasses, useImportJavaClassesWizardI18n, useLanguageServerAvailable, } from "@kie-tools/import-java-classes-component";
import { JavaClassConflictOptions, useImportJavaClasses } from "./useImportJavaClasses";
import { Radio } from "@patternfly/react-core/dist/esm/components/Radio";
const ImportJavaClassesWrapper = ({ javaCodeCompletionService, }) => {
    const { handleConflictAction, handleImportJavaClasses, conflictsClasses, isConflictsOccured } = useImportJavaClasses();
    return (_jsxs(_Fragment, { children: [_jsx(ImportJavaClasses, { loadJavaClassesInDataTypeEditor: handleImportJavaClasses, javaCodeCompletionService: javaCodeCompletionService }), isConflictsOccured && (conflictsClasses === null || conflictsClasses === void 0 ? void 0 : conflictsClasses.length) > 0 && (_jsx(ImportJavaClassNameConflictsModal, { isOpen: isConflictsOccured, handleConfirm: handleConflictAction, confliectedJavaClasses: conflictsClasses }))] }));
};
const ImportJavaClassesDropdownItem = ({ javaCodeCompletionService, ...props }) => {
    const { i18n } = useImportJavaClassesWizardI18n();
    const { isLanguageServerLoading, isLanguageServerDisabled, isLanguageServerError } = useLanguageServerAvailable(javaCodeCompletionService);
    const defineTooltipMessage = React.useCallback(() => {
        if (isLanguageServerDisabled) {
            return i18n.modalButton.disabledMessage;
        }
        else if (isLanguageServerError) {
            return i18n.modalButton.errorMessage;
        }
        return undefined;
    }, [
        isLanguageServerDisabled,
        isLanguageServerError,
        i18n.modalButton.disabledMessage,
        i18n.modalButton.errorMessage,
    ]);
    return (_jsx(_Fragment, { children: defineTooltipMessage() ? (_jsx(Tooltip, { content: defineTooltipMessage(), children: _jsx(DropdownItem, { style: { minWidth: "240px" }, icon: isLanguageServerLoading ? _jsx(Spinner, { size: "md" }) : _jsx(PlusIcon, {}), isDisabled: isLanguageServerDisabled || isLanguageServerLoading, ...props, children: i18n.modalButton.text }) })) : (_jsx(DropdownItem, { style: { minWidth: "240px" }, icon: isLanguageServerLoading ? _jsx(Spinner, { size: "md" }) : _jsx(PlusIcon, {}), isDisabled: isLanguageServerDisabled || isLanguageServerLoading, ...props, children: i18n.modalButton.text })) }));
};
const ImportJavaClassNameConflictsModal = ({ isOpen, handleConfirm, confliectedJavaClasses, }) => {
    const [action, setAction] = useState(JavaClassConflictOptions.REPLACE);
    const handleActionButtonClick = useCallback(() => handleConfirm === null || handleConfirm === void 0 ? void 0 : handleConfirm(action), [handleConfirm, action]);
    const handleRadioBtnClick = useCallback((_, e) => { var _a; return setAction === null || setAction === void 0 ? void 0 : setAction((_a = e === null || e === void 0 ? void 0 : e.target) === null || _a === void 0 ? void 0 : _a.name); }, []);
    const classNames = confliectedJavaClasses === null || confliectedJavaClasses === void 0 ? void 0 : confliectedJavaClasses.map((javaClass) => javaClass === null || javaClass === void 0 ? void 0 : javaClass.name);
    return (_jsx(Modal, { title: "Duplicate DMN Data Type Detected", titleIconVariant: "warning", "aria-describedby": "modal-import-java-classes-conflict-description", showClose: false, isOpen: isOpen, variant: ModalVariant.small, position: "top", actions: [
            _jsx(Button, { variant: "primary", onClick: handleActionButtonClick, children: "Import" }, "import-java-classes-conflict-btn"),
        ], children: _jsxs(TextContent, { children: [(classNames === null || classNames === void 0 ? void 0 : classNames.length) === 1 ? (_jsxs(Text, { component: TextVariants.p, children: ["An existing DMN type named ", _jsx("b", { children: classNames === null || classNames === void 0 ? void 0 : classNames.join() }), " has been detected. This type is currently in use within the system. How would you like to proceed?"] })) : (_jsxs(Text, { component: TextVariants.p, children: ["Multiple DMN types have been detected in the list. The following DMN types are currently in use within the system ", _jsx("b", { children: classNames === null || classNames === void 0 ? void 0 : classNames.join() }), ". How would you like to proceed?"] })), _jsxs(Text, { component: TextVariants.blockquote, style: { background: "none", display: "flex", flexDirection: "column", gap: "1rem" }, children: [_jsx(Radio, { isChecked: action === JavaClassConflictOptions.REPLACE, id: `radio-${JavaClassConflictOptions.REPLACE}`, label: JavaClassConflictOptions.REPLACE, name: JavaClassConflictOptions.REPLACE, onChange: handleRadioBtnClick, description: "This option will replace the existing DMN type with the new one.", isLabelWrapped: true }), _jsx(Radio, { isChecked: action === JavaClassConflictOptions.KEEP_BOTH, id: `radio-${JavaClassConflictOptions.KEEP_BOTH}`, label: JavaClassConflictOptions.KEEP_BOTH, name: JavaClassConflictOptions.KEEP_BOTH, onChange: handleRadioBtnClick, description: "This option will preserve the existing DMN type and create a new one with a unique name.", isLabelWrapped: true })] })] }) }));
};
export { ImportJavaClassesWrapper, ImportJavaClassesDropdownItem, ImportJavaClassNameConflictsModal };
//# sourceMappingURL=ImportJavaClasses.js.map