import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Switch } from "@patternfly/react-core/dist/js/components/Switch";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import * as React from "react";
import { useCallback, useMemo, useState } from "react";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { TypeRefSelector } from "./TypeRefSelector";
import { Dropdown, DropdownItem, DropdownSeparator, KebabToggle, } from "@patternfly/react-core/dist/js/components/Dropdown";
import { DataTypeName } from "./DataTypeName";
import { ItemComponentsTable } from "./ItemComponentsTable";
import { getNewItemDefinition, isStruct } from "./DataTypeSpec";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { CopyIcon } from "@patternfly/react-icons/dist/js/icons/copy-icon";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { buildClipboardFromDataType } from "../clipboard/Clipboard";
import { ConstraintsFromAllowedValuesAttribute, ConstraintsFromTypeConstraintAttribute } from "./Constraints";
import { original } from "immer";
import { builtInFeelTypeNames } from "./BuiltInFeelTypes";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "./useResolvedTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { InfoAltIcon } from "@patternfly/react-icons/dist/js/icons/info-alt-icon";
export function DataTypePanel({ isReadOnly, dataType, allDataTypesById, editItemDefinition, }) {
    var _a, _b;
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const toggleStruct = useCallback((isChecked) => {
        if (isReadOnly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], (itemDefinition) => {
            if (isChecked) {
                itemDefinition.typeRef = undefined;
                itemDefinition.itemComponent = [];
                itemDefinition.typeConstraint = undefined;
                itemDefinition.allowedValues = undefined;
            }
            else {
                itemDefinition.typeRef = { __$$text: DmnBuiltInDataType.Any };
                itemDefinition.itemComponent = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadOnly]);
    const toggleCollection = useCallback((isChecked) => {
        if (isReadOnly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], (itemDefinition) => {
            itemDefinition["@_isCollection"] = isChecked;
            if (isChecked === true) {
                itemDefinition.allowedValues = itemDefinition.typeConstraint
                    ? {
                        ...itemDefinition.typeConstraint,
                    }
                    : undefined;
                itemDefinition.typeConstraint = undefined;
            }
            else {
                itemDefinition.typeConstraint = itemDefinition.allowedValues
                    ? {
                        ...itemDefinition.allowedValues,
                    }
                    : undefined;
                itemDefinition.allowedValues = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadOnly]);
    const changeTypeRef = useCallback((typeRef) => {
        if (isReadOnly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], (itemDefinition) => {
            var _a;
            itemDefinition.typeRef = typeRef ? { __$$text: typeRef } : undefined;
            const originalItemDefinition = original(itemDefinition);
            if (((_a = originalItemDefinition === null || originalItemDefinition === void 0 ? void 0 : originalItemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text) !== typeRef) {
                itemDefinition.typeConstraint = undefined;
                itemDefinition.allowedValues = undefined;
            }
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadOnly]);
    const changeDescription = useCallback((newDescription) => {
        if (isReadOnly) {
            return;
        }
        editItemDefinition(dataType.itemDefinition["@_id"], (itemDefinition) => {
            itemDefinition.description = { __$$text: newDescription };
        });
    }, [dataType.itemDefinition, editItemDefinition, isReadOnly]);
    const parents = useMemo(() => {
        const parents = [];
        let cur = dataType;
        while (cur.parentId) {
            const p = allDataTypesById.get(cur.parentId);
            parents.unshift(p);
            cur = p;
        }
        return parents;
    }, [dataType, allDataTypesById]);
    const addItemComponent = useCallback((id, how, partial) => {
        if (isReadOnly) {
            return;
        }
        editItemDefinition(id, (itemDefinition, items, index, all, state) => {
            var _a;
            const newItemDefinition = getNewItemDefinition(partial);
            (_a = itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : (itemDefinition.itemComponent = []);
            itemDefinition.itemComponent[how](newItemDefinition);
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [editItemDefinition, isReadOnly]);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const [dropdownOpenFor, setDropdownOpenFor] = useState(undefined);
    const [topLevelDropdownOpen, setTopLevelDropdownOpen] = useState(false);
    const { externalModelsByNamespace } = useExternalModels();
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const allTopLevelItemDefinitionUniqueNames = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allTopLevelItemDefinitionUniqueNames);
    const [isCollectionConstraintPopoverOpen, setIsCollectionConstraintPopoverOpen] = useState(false);
    const [isCollectionItemConstraintPopoverOpen, setIsCollectionItemConstraintPopoverOpen] = useState(false);
    const allUniqueNames = useMemo(() => {
        var _a;
        return !dataType.parentId
            ? allTopLevelItemDefinitionUniqueNames
            : ((_a = allDataTypesById.get(dataType.parentId).itemDefinition.itemComponent) !== null && _a !== void 0 ? _a : []).reduce((acc, s) => acc.set(s["@_name"], s["@_id"]), new Map([...builtInFeelTypeNames].map((s) => [s, s])));
    }, [allDataTypesById, allTopLevelItemDefinitionUniqueNames, dataType.parentId]);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const resolvedTypeRef = useResolvedTypeRef((_a = dataType.itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text, dataType.namespace);
    return (_jsxs(_Fragment, { children: [_jsxs(Flex, { className: `kie-dmn-editor--sticky-top-glass-header kie-dmn-editor--data-type-panel-header ${parents.length > 0 || dataType.namespace !== thisDmnsNamespace
                    ? "kie-dmn-editor--data-type-panel-header-nested-or-external"
                    : ""}`, justifyContent: { default: "justifyContentSpaceBetween" }, direction: { default: "row" }, children: [_jsx(FlexItem, { children: _jsxs(Flex, { direction: { default: "column" }, children: [_jsx(FlexItem, { children: _jsxs(Flex, { direction: { default: "row" }, children: [dataType.namespace !== thisDmnsNamespace && (_jsx(FlexItem, { children: _jsx(Label, { children: "External" }) })), parents.length > 0 && (_jsx(FlexItem, { className: "kie-dmn-editor--data-type-parents", children: parents.map((p) => (_jsx(Button, { variant: ButtonVariant.link, onClick: () => {
                                                        dmnEditorStoreApi.setState((state) => {
                                                            state.dataTypesEditor.activeItemDefinitionId = p.itemDefinition["@_id"];
                                                        });
                                                    }, children: buildFeelQNameFromNamespace({
                                                        namedElement: p.itemDefinition,
                                                        importsByNamespace,
                                                        namespace: p.namespace,
                                                        relativeToNamespace: !p.parentId ? thisDmnsNamespace : p.namespace,
                                                    }).full }, p.itemDefinition["@_id"]))) }))] }) }), _jsx(FlexItem, { children: _jsx("div", { className: "kie-dmn-editor--data-types-title", children: _jsx(DataTypeName, { relativeToNamespace: !dataType.parentId ? thisDmnsNamespace : dataType.namespace, itemDefinition: dataType.itemDefinition, isActive: false, editMode: "hover", isReadOnly: isReadOnly || dataType.namespace !== thisDmnsNamespace, onGetAllUniqueNames: () => allUniqueNames }) }) })] }) }), _jsx(FlexItem, { children: _jsx(Dropdown, { toggle: _jsx(KebabToggle, { id: "toggle-kebab-top-level", onToggle: setTopLevelDropdownOpen }), onSelect: () => setTopLevelDropdownOpen(false), isOpen: topLevelDropdownOpen, menuAppendTo: document.body, isPlain: true, position: "right", dropdownItems: [
                                _jsx(DropdownItem, { isDisabled: true, icon: _jsx(_Fragment, {}), children: _jsxs("div", { children: [_jsx("b", { children: "ID: " }), dataType.itemDefinition["@_id"]] }) }, "id"),
                                _jsx(DropdownSeparator, { style: { marginBottom: "8px" } }, "separator-1"),
                                _jsx(DropdownItem, { icon: _jsx(CopyIcon, {}), onClick: () => {
                                        const clipboard = buildClipboardFromDataType(dataType, thisDmnsNamespace);
                                        navigator.clipboard.writeText(JSON.stringify(clipboard));
                                    }, children: "Copy" }, "copy"),
                                _jsx(React.Fragment, { children: !isReadOnly && (_jsxs(_Fragment, { children: [_jsx(DropdownSeparator, {}, "separator-2"), _jsx(DropdownItem, { style: { minWidth: "240px" }, icon: _jsx(TrashIcon, {}), onClick: () => {
                                                    if (isReadOnly) {
                                                        return;
                                                    }
                                                    editItemDefinition(dataType.itemDefinition["@_id"], (_, items) => {
                                                        items === null || items === void 0 ? void 0 : items.splice(dataType.index, 1);
                                                    });
                                                    dmnEditorStoreApi.setState((state) => {
                                                        var _a, _b, _c;
                                                        state.dataTypesEditor.activeItemDefinitionId =
                                                            (_a = dataType.parentId) !== null && _a !== void 0 ? _a : (_c = (_b = state.dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c["@_id"];
                                                    });
                                                }, children: "Remove" })] })) }, "remove-fragment"),
                            ] }) })] }), _jsxs(PageSection, { style: { padding: "24px" }, children: [_jsx(TextArea, { isDisabled: isReadOnly, value: (_b = dataType.itemDefinition.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: changeDescription, placeholder: "Enter a description...", resizeOrientation: "vertical", "aria-label": "Data type description" }, dataType.itemDefinition["@_id"]), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), _jsx(Switch, { label: "Is collection?", isChecked: !!dataType.itemDefinition["@_isCollection"], onChange: toggleCollection, isDisabled: isReadOnly }), _jsx("br", {}), _jsx("br", {}), _jsx(Switch, { label: "Is struct?", isChecked: isStruct(dataType.itemDefinition), onChange: toggleStruct, isDisabled: isReadOnly }), _jsx("br", {}), _jsx("br", {}), _jsx(Divider, { inset: { default: "insetMd" } }), _jsx("br", {}), !isStruct(dataType.itemDefinition) && (_jsxs(_Fragment, { children: [_jsx(Title, { size: "md", headingLevel: "h4", children: "Type" }), _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, isDisabled: isReadOnly, typeRef: resolvedTypeRef, onChange: changeTypeRef, removeDataTypes: [dataType] }), _jsx("br", {}), _jsx("br", {}), dataType.itemDefinition["@_isCollection"] === true ? (_jsxs(_Fragment, { children: [_jsxs(Flex, { direction: { default: "row" }, alignItems: { default: "alignItemsCenter" }, children: [_jsx(Title, { size: "md", headingLevel: "h4", children: "Collection constraint" }), _jsx(Popover, { showClose: false, isVisible: isCollectionConstraintPopoverOpen, shouldClose: () => setIsCollectionConstraintPopoverOpen(false), headerContent: "Collection Constraints (Type Constraint)", headerIcon: _jsx(InfoAltIcon, {}), headerComponent: "h1", bodyContent: _jsxs("p", { children: ["As per the DMN specification, the ", _jsx("b", { children: "Type Constraint" }), " attribute lists the possible values", _jsx("br", {}), "or ranges of values in the base type that are allowed in this ItemDefinition."] }), children: _jsx(InfoAltIcon, { onMouseEnter: () => setIsCollectionConstraintPopoverOpen(true), onMouseLeave: () => setIsCollectionConstraintPopoverOpen(false) }) })] }), _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: isReadOnly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition, defaultsToAllowedValues: false }), _jsx("br", {}), _jsx("br", {}), _jsxs(Flex, { direction: { default: "row" }, alignItems: { default: "alignItemsCenter" }, children: [_jsx(Title, { size: "md", headingLevel: "h4", children: "Collection item constraint" }), _jsx(Popover, { showClose: false, isVisible: isCollectionItemConstraintPopoverOpen, shouldClose: () => setIsCollectionItemConstraintPopoverOpen(false), headerContent: "Collection Item Constraints (Allowed Values)", headerIcon: _jsx(InfoAltIcon, {}), headerComponent: "h1", bodyContent: _jsxs("p", { children: ["As per the DMN specification, the ", _jsx("b", { children: "Allowed Values" }), " attribute lists the possible values", _jsx("br", {}), "or ranges of values in the base type that are allowed in this ItemDefinition."] }), children: _jsx(InfoAltIcon, { onMouseEnter: () => setIsCollectionItemConstraintPopoverOpen(true), onMouseLeave: () => setIsCollectionItemConstraintPopoverOpen(false) }) })] }), _jsx(Alert, { variant: "warning", isInline: true, isPlain: true, title: "Deprecated", children: _jsx("p", { children: "Creating constraints for the collection items directly on the collection itself is deprecated since DMN 1.5 and will possibly be removed in future versions. To prepare your DMN model for future updates, please create a dedicated Data Type for the items of this list and add constraints there." }) }), _jsx("br", {}), _jsx(ConstraintsFromAllowedValuesAttribute, { isReadOnly: isReadOnly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition })] })) : (_jsxs(_Fragment, { children: [_jsx(Title, { size: "md", headingLevel: "h4", children: "Constraints" }), _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: isReadOnly, itemDefinition: dataType.itemDefinition, editItemDefinition: editItemDefinition, defaultsToAllowedValues: true })] }))] })), isStruct(dataType.itemDefinition) && (_jsx(ItemComponentsTable, { isReadOnly: isReadOnly, addItemComponent: addItemComponent, allDataTypesById: allDataTypesById, parent: dataType, editItemDefinition: editItemDefinition, dropdownOpenFor: dropdownOpenFor, setDropdownOpenFor: setDropdownOpenFor }))] })] }));
}
//# sourceMappingURL=DataTypePanel.js.map