import * as React from "react";
import { DMN15__tItemDefinition, DMN15__tUnaryTests } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { KIE__tConstraintType } from "@kie-tools/dmn-marshaller/dist/schemas/kie-1_0/ts-gen/types";
import { DataTypeIndex, EditItemDefinition } from "./DataTypes";
import { ConstraintProps } from "./ConstraintComponents/Constraint";
import { UniqueNameIndex } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
export type TypeHelper = {
    check: (value: string) => boolean;
    parse: (value: string) => any;
    transform: (value: string) => string;
    recover: (value?: string) => string | undefined;
    component: (props: ConstraintProps) => React.ReactNode | undefined;
};
export interface ConstraintComponentProps {
    id: string;
    isReadOnly: boolean;
    value?: string;
    expressionValue?: string;
    type: DmnBuiltInDataType;
    typeHelper: TypeHelper;
    onSave: (value?: string) => void;
    isDisabled: boolean;
    renderOnPropertiesPanel?: boolean;
}
declare enum ConstraintsType {
    ENUMERATION = "Enumeration",
    EXPRESSION = "Expression",
    RANGE = "Range",
    NONE = "None"
}
export declare function recursivelyGetRootItemDefinition(itemDefinition: Normalized<DMN15__tItemDefinition>, allDataTypesById: DataTypeIndex, allTopLevelItemDefinitionUniqueNames: UniqueNameIndex): Normalized<DMN15__tItemDefinition>;
export declare const constraintTypeHelper: (itemDefinition: Normalized<DMN15__tItemDefinition>, allDataTypesById?: DataTypeIndex, allTopLevelItemDefinitionUniqueNames?: UniqueNameIndex) => TypeHelper;
export declare function useConstraint({ constraint, itemDefinition, isCollectionConstraintEnabled, constraintTypeHelper, enabledConstraints, }: {
    constraint: Normalized<DMN15__tUnaryTests> | undefined;
    itemDefinition: Normalized<DMN15__tItemDefinition>;
    isCollectionConstraintEnabled: boolean;
    constraintTypeHelper: TypeHelper;
    enabledConstraints: KIE__tConstraintType[] | undefined;
}): {
    constraintValue: string | undefined;
    isConstraintEnum: string[] | undefined;
    isConstraintRange: [string, string] | undefined;
    isConstraintEnabled: {
        enumeration: boolean;
        range: boolean;
        expression: boolean;
    };
    selectedKieConstraintType: ConstraintsType;
    enumToKieConstraintType: (selection: ConstraintsType) => KIE__tConstraintType | undefined;
};
export declare function ConstraintsFromAllowedValuesAttribute({ isReadOnly, itemDefinition, editItemDefinition, renderOnPropertiesPanel, }: {
    isReadOnly: boolean;
    itemDefinition: Normalized<DMN15__tItemDefinition>;
    editItemDefinition: EditItemDefinition;
    renderOnPropertiesPanel?: boolean;
    isEnumDisabled?: boolean;
    isRangeDisabled?: boolean;
}): JSX.Element;
export declare function ConstraintsFromTypeConstraintAttribute({ isReadOnly, itemDefinition, editItemDefinition, renderOnPropertiesPanel, defaultsToAllowedValues, }: {
    isReadOnly: boolean;
    itemDefinition: Normalized<DMN15__tItemDefinition>;
    editItemDefinition: EditItemDefinition;
    renderOnPropertiesPanel?: boolean;
    defaultsToAllowedValues: boolean;
}): JSX.Element;
export declare function Constraints({ isReadOnly, itemDefinitionId, constraintValue, typeHelper, typeRef, isConstraintEnum, isConstraintRange, isConstraintEnabled, selectedKieConstraintType, onToggleGroupChange, onConstraintChange, renderOnPropertiesPanel, }: {
    isReadOnly: boolean;
    itemDefinitionId: string;
    constraintValue: string | undefined;
    typeHelper: TypeHelper;
    typeRef: DmnBuiltInDataType;
    isConstraintEnum: string[] | undefined;
    isConstraintRange: [string, string] | undefined;
    isConstraintEnabled: {
        enumeration: boolean;
        range: boolean;
        expression: boolean;
    };
    selectedKieConstraintType: ConstraintsType;
    renderOnPropertiesPanel?: boolean;
    onToggleGroupChange: (selected: boolean, selectedConstraint: ConstraintsType) => void;
    onConstraintChange: (value: string | undefined, selectedConstraint: ConstraintsType) => void;
}): JSX.Element;
export {};
//# sourceMappingURL=Constraints.d.ts.map