export function generateBoxedExpressionIndex(expression, parentMap, parentExpressionPath) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    const map = parentMap ? parentMap : new Map();
    switch (expression === null || expression === void 0 ? void 0 : expression.__$$element) {
        case "conditional":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "conditional", root: expression["@_id"] }],
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.if.expression, map, [
                ...parentExpressionPath,
                { type: "conditional", row: "if", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.else.expression, map, [
                ...parentExpressionPath,
                { type: "conditional", row: "else", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.then.expression, map, [
                ...parentExpressionPath,
                { type: "conditional", row: "then", root: expression["@_id"] },
            ]);
            return map;
        case "context":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "context", root: expression["@_id"] }],
                    cell: expression,
                });
            (_a = expression.contextEntry) === null || _a === void 0 ? void 0 : _a.forEach((ce, row) => {
                var _a, _b;
                const id = (_b = (_a = ce.variable) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : ce === null || ce === void 0 ? void 0 : ce["@_id"];
                id &&
                    ce.variable &&
                    map.set(id, {
                        expressionPath: [
                            ...parentExpressionPath,
                            { type: "context", row, column: "variable", root: expression["@_id"] },
                        ],
                        cell: ce.variable,
                    });
                generateBoxedExpressionIndex(ce.expression, map, [
                    ...parentExpressionPath,
                    { type: "context", row, column: "expression", root: expression["@_id"] },
                ]);
            });
            return map;
        case "decisionTable":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "decisionTable", root: expression["@_id"] }],
                    cell: expression,
                });
            expression.output.forEach((o, column) => o["@_id"] &&
                map.set(o["@_id"], {
                    expressionPath: [
                        ...parentExpressionPath,
                        { type: "decisionTable", header: "output", row: -1, column, root: expression["@_id"] },
                    ],
                    cell: o,
                }));
            (_b = expression.input) === null || _b === void 0 ? void 0 : _b.forEach((i, column) => {
                i["@_id"] &&
                    map.set(i["@_id"], {
                        expressionPath: [
                            ...parentExpressionPath,
                            { type: "decisionTable", header: "input", row: -1, column, root: expression["@_id"] },
                        ],
                        cell: i,
                    });
            });
            (_c = expression.rule) === null || _c === void 0 ? void 0 : _c.forEach((r, row) => {
                var _a, _b;
                (_a = r.outputEntry) === null || _a === void 0 ? void 0 : _a.forEach((ro, column) => ro["@_id"] &&
                    map.set(ro["@_id"], {
                        expressionPath: [
                            ...parentExpressionPath,
                            { type: "decisionTable", header: "output", row, column, root: expression["@_id"] },
                        ],
                        cell: ro,
                    }));
                (_b = r.inputEntry) === null || _b === void 0 ? void 0 : _b.forEach((ri, column) => ri["@_id"] &&
                    map.set(ri["@_id"], {
                        expressionPath: [
                            ...parentExpressionPath,
                            { type: "decisionTable", header: "input", row, column, root: expression["@_id"] },
                        ],
                        cell: ri,
                    }));
            });
            return map;
        case "every":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "every", root: expression["@_id"] }],
                    cell: expression,
                });
            expression["@_id"] &&
                map.set(`${expression["@_id"]}-iteratorVariable`, {
                    expressionPath: [...parentExpressionPath, { type: "every", row: "variable", root: expression["@_id"] }],
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, [
                ...parentExpressionPath,
                { type: "every", row: "in", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.satisfies.expression, map, [
                ...parentExpressionPath,
                { type: "every", row: "statisfies", root: expression["@_id"] },
            ]);
            return map;
        case "filter":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "filter", root: expression["@_id"] }],
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, [
                ...parentExpressionPath,
                { type: "filter", row: "in", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.match.expression, map, [
                ...parentExpressionPath,
                { type: "filter", row: "match", root: expression["@_id"] },
            ]);
            return map;
        case "for":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "for", root: expression["@_id"] }],
                    cell: expression,
                });
            expression["@_id"] &&
                map.set(`${expression["@_id"]}-iteratorVariable`, {
                    expressionPath: [...parentExpressionPath, { type: "for", row: "variable", root: expression["@_id"] }],
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, [
                ...parentExpressionPath,
                { type: "for", row: "in", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.return.expression, map, [
                ...parentExpressionPath,
                { type: "for", row: "return", root: expression["@_id"] },
            ]);
            return map;
        case "functionDefinition":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "functionDefinition", root: expression["@_id"] }],
                    cell: expression,
                });
            if ((_d = expression.expression) === null || _d === void 0 ? void 0 : _d["@_id"]) {
                generateBoxedExpressionIndex(expression.expression, map, [
                    ...parentExpressionPath,
                    { type: "functionDefinition", parameterIndex: -1, root: expression["@_id"] },
                ]);
            }
            map.set(`${expression["@_id"]}-parameters`, {
                expressionPath: [
                    ...parentExpressionPath,
                    { type: "functionDefinition", parameterIndex: 0, root: expression["@_id"] },
                ],
                cell: (_e = expression.formalParameter) !== null && _e !== void 0 ? _e : [],
            });
            return map;
        case "invocation":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "invocation", root: expression["@_id"] }],
                    cell: expression,
                });
            (_f = expression.binding) === null || _f === void 0 ? void 0 : _f.forEach((b, row) => {
                b.parameter["@_id"] &&
                    map.set(b.parameter["@_id"], {
                        expressionPath: [
                            ...parentExpressionPath,
                            { type: "invocation", row, column: "parameter", root: expression["@_id"] },
                        ],
                        cell: b.parameter,
                    });
                b.expression &&
                    generateBoxedExpressionIndex(b.expression, map, [
                        ...parentExpressionPath,
                        { type: "invocation", row, column: "expression", root: expression["@_id"] },
                    ]);
            });
            expression.expression &&
                expression.expression["@_id"] &&
                map.set(expression.expression["@_id"], {
                    expressionPath: [
                        ...parentExpressionPath,
                        { type: "invocation", row: -1, column: "expression", root: expression["@_id"] },
                    ],
                    cell: expression.expression,
                });
            return map;
        case "list":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "list", root: expression["@_id"] }],
                    cell: expression,
                });
            (_g = expression.expression) === null || _g === void 0 ? void 0 : _g.forEach((e, row) => generateBoxedExpressionIndex(e, map, [
                ...parentExpressionPath,
                { type: "list", row, root: expression["@_id"] },
            ]));
            return map;
        case "literalExpression":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "literalExpression", root: expression["@_id"] }],
                    cell: expression,
                });
            return map;
        case "relation":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "relation", root: expression["@_id"] }],
                    cell: expression,
                });
            (_h = expression.column) === null || _h === void 0 ? void 0 : _h.forEach((c, column) => c["@_id"] &&
                map.set(c["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "relation", row: -1, column, root: expression["@_id"] }],
                    cell: c,
                }));
            (_j = expression.row) === null || _j === void 0 ? void 0 : _j.forEach((r, row) => {
                var _a;
                return (_a = r.expression) === null || _a === void 0 ? void 0 : _a.forEach((re, column) => {
                    re["@_id"] &&
                        map.set(re["@_id"], {
                            expressionPath: [...parentExpressionPath, { type: "relation", row, column, root: expression["@_id"] }],
                            cell: re,
                        });
                });
            });
            return map;
        case "some":
            expression["@_id"] &&
                map.set(expression["@_id"], {
                    expressionPath: [...parentExpressionPath, { type: "some", root: expression["@_id"] }],
                    cell: expression,
                });
            expression["@_id"] &&
                map.set(`${expression["@_id"]}-iteratorVariable`, {
                    expressionPath: [...parentExpressionPath, { type: "some", row: "variable", root: expression["@_id"] }],
                    cell: expression,
                });
            generateBoxedExpressionIndex(expression.in.expression, map, [
                ...parentExpressionPath,
                { type: "some", row: "in", root: expression["@_id"] },
            ]);
            generateBoxedExpressionIndex(expression.satisfies.expression, map, [
                ...parentExpressionPath,
                { type: "some", row: "statisfies", root: expression["@_id"] },
            ]);
            return map;
    }
}
export function getDmnObjectByPath(paths, expressionRoot) {
    if (!expressionRoot) {
        return;
    }
    return paths.reduce((expressionToEdit, path) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
        if (path.type === "conditional") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "if") {
                return expressionToEdit.if.expression;
            }
            if (path.row === "else") {
                return expressionToEdit.else.expression;
            }
            return expressionToEdit.then.expression;
        }
        if (path.type === "context") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.column === "expression") {
                return (_a = expressionToEdit.contextEntry) === null || _a === void 0 ? void 0 : _a[path.row].expression;
            }
            return (_b = expressionToEdit.contextEntry) === null || _b === void 0 ? void 0 : _b[path.row].variable;
        }
        if (path.type === "decisionTable") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.header === "input") {
                if (path.row < 0) {
                    return (_c = expressionToEdit.input) === null || _c === void 0 ? void 0 : _c[path.column];
                }
                return (_e = (_d = expressionToEdit.rule) === null || _d === void 0 ? void 0 : _d[path.row].inputEntry) === null || _e === void 0 ? void 0 : _e[path.column];
            }
            if (path.row < 0) {
                return (_f = expressionToEdit.output) === null || _f === void 0 ? void 0 : _f[path.column];
            }
            return (_h = (_g = expressionToEdit.rule) === null || _g === void 0 ? void 0 : _g[path.row].outputEntry) === null || _h === void 0 ? void 0 : _h[path.column];
        }
        if (path.type === "every") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.satisfies.expression;
        }
        if (path.type === "filter") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.match.expression;
        }
        if (path.type === "for") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.return.expression;
        }
        if (path.type === "functionDefinition") {
            if (!path.parameterIndex) {
                return expressionToEdit;
            }
            if (path.parameterIndex < 0) {
                return expressionToEdit.expression;
            }
            return expressionToEdit;
        }
        if (path.type === "invocation") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.column === "parameter") {
                return (_j = expressionToEdit.binding) === null || _j === void 0 ? void 0 : _j[path.row].parameter;
            }
            if (path.column === "expression" && path.row >= 0) {
                return (_k = expressionToEdit.binding) === null || _k === void 0 ? void 0 : _k[path.row].expression;
            }
            return expressionToEdit.expression;
        }
        if (path.type === "list") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            return (_l = expressionToEdit.expression) === null || _l === void 0 ? void 0 : _l[path.row];
        }
        if (path.type === "literalExpression") {
            return expressionToEdit;
        }
        if (path.type === "relation") {
            if (path.row === undefined || path.column === undefined) {
                return expressionToEdit;
            }
            if (path.row < 0) {
                return (_m = expressionToEdit.column) === null || _m === void 0 ? void 0 : _m[path.column];
            }
            return (_p = (_o = expressionToEdit.row) === null || _o === void 0 ? void 0 : _o[path.row].expression) === null || _p === void 0 ? void 0 : _p[path.column];
        }
        if (path.type === "some") {
            if (path.row === undefined) {
                return expressionToEdit;
            }
            if (path.row === "variable") {
                return expressionToEdit;
            }
            if (path.row === "in") {
                return expressionToEdit.in.expression;
            }
            return expressionToEdit.satisfies.expression;
        }
    }, expressionRoot);
}
//# sourceMappingURL=boxedExpressionIndex.js.map