import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Action, generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { BoxedExpressionEditor } from "@kie-tools/boxed-expression-component/dist/BoxedExpressionEditor";
import { FeelIdentifiers } from "@kie-tools/dmn-feel-antlr4-parser";
import { IdentifiersRefactor } from "@kie-tools/dmn-language-service";
import { PMMLDocumentData } from "@kie-tools/pmml-editor-marshaller/dist/api";
import { PMMLFieldData } from "@kie-tools/pmml-editor-marshaller/dist/api/PMMLFieldData";
import { PMMLModelData } from "@kie-tools/pmml-editor-marshaller/dist/api/PMMLModelData";
import { AnomalyDetectionModel, AssociationModel, BaselineModel, BayesianNetworkModel, ClusteringModel, GaussianProcessModel, GeneralRegressionModel, MiningModel, NaiveBayesModel, NearestNeighborModel, NeuralNetwork, RegressionModel, RuleSetModel, Scorecard, SequenceModel, SupportVectorMachineModel, TextModel, TimeSeriesModel, TreeModel, } from "@kie-tools/pmml-editor-marshaller/dist/marshaller/model/pmml4_4";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { ArrowRightIcon } from "@patternfly/react-icons/dist/js/icons/arrow-right-icon";
import { InfoIcon } from "@patternfly/react-icons/dist/js/icons/info-icon";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { builtInFeelTypes } from "../dataTypes/BuiltInFeelTypes";
import { isStruct } from "../dataTypes/DataTypeSpec";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { NodeIcon } from "../icons/Icons";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { updateExpression } from "../mutations/updateExpression";
import { updateExpressionWidths } from "../mutations/updateExpressionWidths";
import { DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { getDefaultColumnWidth } from "@kie-tools/boxed-expression-component/dist/resizing/WidthsToFitData";
import { getDefaultBoxedExpression } from "./getDefaultBoxedExpression";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { renameDrgElement } from "../mutations/renameNode";
import { updateDrgElementType } from "../mutations/updateDrgElementType";
import { isIdentifierReferencedInSomeExpression, RefactorConfirmationDialog, } from "../refactor/RefactorConfirmationDialog";
import { EvaluationHighlightsBadge } from "../evaluationHighlights/EvaluationHighlightsBadge";
import { useDmnEditor } from "../DmnEditorContext";
export function BoxedExpressionScreen({ container }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;
    const { externalModelsByNamespace } = useExternalModels();
    const settings = useSettings();
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const activeDrgElementId = useDmnEditorStore((s) => s.boxedExpressionEditor.activeDrgElementId);
    const isPropertiesPanelOpen = useDmnEditorStore((s) => s.boxedExpressionEditor.propertiesPanel.isOpen);
    const externalDmnsByNamespace = useDmnEditorStore((s) => s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).dmns);
    const dataTypesTree = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).dataTypesTree);
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const externalPmmlsByNamespace = useDmnEditorStore((s) => s.computed(s).getDirectlyIncludedExternalModelsByNamespace(externalModelsByNamespace).pmmls);
    const isAlternativeInputDataShape = useDmnEditorStore((s) => s.computed(s).isAlternativeInputDataShape());
    const drdIndex = useDmnEditorStore((s) => s.computed(s).getDrdIndex());
    const externalDmnModelsByNamespaceMap = useDmnEditorStore((s) => s.computed(s).getExternalDmnModelsByNamespaceMap(externalModelsByNamespace));
    const { evaluationResultsByNodeId } = useDmnEditor();
    const isEvaluationHighlightsEnabled = useDmnEditorStore((s) => s.diagram.overlays.enableEvaluationHighlights);
    const onRequestFeelIdentifiers = useCallback(() => {
        return new FeelIdentifiers({
            _readonly_dmnDefinitions: dmnEditorStoreApi.getState().dmn.model.definitions,
            _readonly_externalDefinitions: externalDmnModelsByNamespaceMap,
        });
    }, [dmnEditorStoreApi, externalDmnModelsByNamespaceMap]);
    const drgElementIndex = useMemo(() => {
        var _a;
        if (!activeDrgElementId) {
            return undefined;
        }
        return ((_a = thisDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).findIndex((e) => e["@_id"] === activeDrgElementId);
    }, [activeDrgElementId, thisDmn.model.definitions.drgElement]);
    const drgElement = useMemo(() => {
        var _a;
        if (drgElementIndex === undefined) {
            return undefined;
        }
        const drgElement = (_a = thisDmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex];
        if (!((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "decision" || (drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "businessKnowledgeModel")) {
            return undefined;
        }
        return drgElement;
    }, [drgElementIndex, thisDmn.model.definitions.drgElement]);
    const widthsById = useMemo(() => {
        var _a, _b, _c, _d, _e;
        return ((_e = (_d = (_c = (_b = (_a = thisDmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[drdIndex]["di:extension"]) === null || _c === void 0 ? void 0 : _c["kie:ComponentsWidthsExtension"]) === null || _d === void 0 ? void 0 : _d["kie:ComponentWidths"]) !== null && _e !== void 0 ? _e : []).reduce((acc, c) => {
            var _a;
            if (c["@_dmnElementRef"] === undefined) {
                return acc;
            }
            else {
                return acc.set(c["@_dmnElementRef"], ((_a = c["kie:width"]) !== null && _a !== void 0 ? _a : []).map((vv) => vv.__$$text));
            }
        }, new Map());
    }, [drdIndex, thisDmn.model.definitions]);
    const expression = useMemo(() => {
        if (!drgElement) {
            return undefined;
        }
        return {
            boxedExpression: drgElementToBoxedExpression(drgElement),
            drgElementIndex,
            drgElement,
            drgElementType: drgElement.__$$element,
        };
    }, [drgElement, drgElementIndex]);
    const widthsByIdRef = useRef(widthsById);
    const boxedExpressionRef = useRef(expression === null || expression === void 0 ? void 0 : expression.boxedExpression);
    useEffect(() => {
        widthsByIdRef.current = widthsById;
    }, [widthsById]);
    useEffect(() => {
        boxedExpressionRef.current = expression === null || expression === void 0 ? void 0 : expression.boxedExpression;
    }, [expression === null || expression === void 0 ? void 0 : expression.boxedExpression]);
    const onWidthsChange = useCallback((newWidthsByIdAction) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            const newWidthsById = typeof newWidthsByIdAction === "function"
                ? newWidthsByIdAction((_a = widthsByIdRef.current) !== null && _a !== void 0 ? _a : new Map())
                : newWidthsByIdAction;
            widthsByIdRef.current = newWidthsById;
            updateExpressionWidths({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                widthsById: newWidthsById,
            });
        });
    }, [dmnEditorStoreApi]);
    const setExpression = useCallback((args) => {
        var _a;
        boxedExpressionRef.current = args.expression;
        updateExpression({
            definitions: args.definitions,
            expression: args.expression,
            drgElementIndex: (_a = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _a !== void 0 ? _a : 0,
            externalDmnModelsByNamespaceMap,
        });
    }, [expression === null || expression === void 0 ? void 0 : expression.drgElementIndex, externalDmnModelsByNamespaceMap]);
    const [isRefactorModalOpen, setIsRefactorModalOpen] = useState(false);
    const [variableChangedArgs, setVariableChangedArgs] = useState();
    const [newExpression, setNewExpression] = useState();
    const refactor = useCallback(() => {
        if (!variableChangedArgs) {
            throw new Error("Can not refactor because `variableChangedArgs` are not set in BoxedExpressionScreen.");
        }
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d, _e, _f;
            const drgElement = (_a = state.dmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[(_b = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _b !== void 0 ? _b : 0];
            if ((drgElement === null || drgElement === void 0 ? void 0 : drgElement["@_id"]) === variableChangedArgs.variableUuid) {
                renameDrgElement({
                    definitions: state.dmn.model.definitions,
                    newName: (_c = newExpression === null || newExpression === void 0 ? void 0 : newExpression["@_label"]) !== null && _c !== void 0 ? _c : drgElement["@_name"],
                    index: (_d = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _d !== void 0 ? _d : 0,
                    externalDmnModelsByNamespaceMap,
                    shouldRenameReferencedExpressions: true,
                });
            }
            else {
                const identifiersRefactor = new IdentifiersRefactor({
                    writeableDmnDefinitions: state.dmn.model.definitions,
                    _readonly_externalDmnModelsByNamespaceMap: externalDmnModelsByNamespaceMap,
                });
                identifiersRefactor.rename({
                    identifierUuid: variableChangedArgs.variableUuid,
                    newName: (_f = (_e = variableChangedArgs.nameChange) === null || _e === void 0 ? void 0 : _e.to) !== null && _f !== void 0 ? _f : "",
                });
            }
        });
    }, [
        dmnEditorStoreApi,
        expression === null || expression === void 0 ? void 0 : expression.drgElementIndex,
        externalDmnModelsByNamespaceMap,
        newExpression,
        variableChangedArgs,
    ]);
    const onExpressionChange = useCallback((args) => {
        dmnEditorStoreApi.setState((state) => {
            var _a, _b;
            const newExpression = typeof args.setExpressionAction === "function"
                ? args.setExpressionAction(boxedExpressionRef.current)
                : args.setExpressionAction;
            if (!args.expressionChangedArgs) {
                setExpression({ definitions: state.dmn.model.definitions, expression: newExpression });
            }
            else {
                if (args.expressionChangedArgs.action === Action.VariableChanged) {
                    if (args.expressionChangedArgs.typeChange && !args.expressionChangedArgs.nameChange) {
                        updateDrgElementType({
                            definitions: state.dmn.model.definitions,
                            expression: newExpression,
                            drgElementIndex: (_a = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _a !== void 0 ? _a : 0,
                        });
                        setExpression({ definitions: state.dmn.model.definitions, expression: newExpression });
                    }
                    else if (args.expressionChangedArgs.typeChange) {
                        const identifiersRefactor = new IdentifiersRefactor({
                            writeableDmnDefinitions: state.dmn.model.definitions,
                            _readonly_externalDmnModelsByNamespaceMap: externalDmnModelsByNamespaceMap,
                        });
                        identifiersRefactor.changeType({
                            identifierUuid: args.expressionChangedArgs.variableUuid,
                            newType: args.expressionChangedArgs.typeChange.to,
                        });
                        updateDrgElementType({
                            definitions: state.dmn.model.definitions,
                            expression: newExpression,
                            drgElementIndex: (_b = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _b !== void 0 ? _b : 0,
                        });
                    }
                    if (args.expressionChangedArgs.nameChange) {
                        setVariableChangedArgs(args.expressionChangedArgs);
                        setNewExpression(newExpression);
                        if (isIdentifierReferencedInSomeExpression({
                            identifierUuid: args.expressionChangedArgs.variableUuid,
                            dmnDefinitions: state.dmn.model.definitions,
                            externalDmnModelsByNamespaceMap,
                        })) {
                            setIsRefactorModalOpen(true);
                        }
                        else {
                            setExpression({ definitions: state.dmn.model.definitions, expression: newExpression });
                        }
                    }
                }
                else {
                    setExpression({ definitions: state.dmn.model.definitions, expression: newExpression });
                }
            }
        });
    }, [dmnEditorStoreApi, expression === null || expression === void 0 ? void 0 : expression.drgElementIndex, externalDmnModelsByNamespaceMap, setExpression]);
    const isResetSupportedOnRootExpression = useMemo(() => {
        return (expression === null || expression === void 0 ? void 0 : expression.drgElementType) === "decision";
    }, [expression === null || expression === void 0 ? void 0 : expression.drgElementType]);
    const dataTypes = useMemo(() => {
        const customDataTypes = dataTypesTree.map((d) => ({
            isCustom: true,
            name: d.feelName,
        }));
        return [...builtInFeelTypes, ...customDataTypes];
    }, [dataTypesTree]);
    const pmmlDocuments = useMemo(() => {
        return [...externalPmmlsByNamespace.entries()].flatMap(([namespace, pmml]) => {
            const documentData = getPmmlDocumentData(pmml.model);
            const _import = importsByNamespace.get(namespace);
            if (!_import) {
                return [];
            }
            return {
                document: _import["@_name"],
                modelsFromDocument: documentData.models.map((m) => ({
                    model: m.modelName,
                    parametersFromModel: m.fields.map((f) => ({
                        "@_id": generateUuid(),
                        "@_name": f.fieldName,
                        description: { __$$text: f.fieldName },
                    })),
                })),
            };
        });
    }, [importsByNamespace, externalPmmlsByNamespace]);
    const beeGwtService = useMemo(() => {
        return {
            getDefaultExpressionDefinition(logicType, typeRef, isRoot) {
                const s = dmnEditorStoreApi.getState();
                const c = s.computed(s);
                const allTopLevelDataTypesByFeelName = c.getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName;
                const nodesById = c.getDiagramData(externalModelsByNamespace).nodesById;
                const defaultWidthsById = new Map();
                const defaultExpression = getDefaultBoxedExpression({
                    logicType,
                    typeRef,
                    allTopLevelDataTypesByFeelName,
                    widthsById: defaultWidthsById,
                    getDefaultColumnWidth,
                    getInputs: () => {
                        var _a;
                        const drgElement = (_a = s.dmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex !== null && drgElementIndex !== void 0 ? drgElementIndex : 0];
                        if (!isRoot || (drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) !== "decision") {
                            return undefined;
                        }
                        else {
                            return determineInputsForDecision(drgElement, allTopLevelDataTypesByFeelName, nodesById);
                        }
                    },
                });
                return {
                    expression: defaultExpression,
                    widthsById: defaultWidthsById,
                };
            },
            selectObject(uuid) {
                dmnEditorStoreApi.setState((state) => {
                    state.boxedExpressionEditor.selectedObjectId = uuid;
                });
            },
            openDataTypePage() {
                dmnEditorStoreApi.setState((state) => {
                    state.navigation.tab = DmnEditorTab.DATA_TYPES;
                });
            },
        };
    }, [dmnEditorStoreApi, drgElementIndex, externalModelsByNamespace]);
    const Icon = useMemo(() => {
        if (!drgElement) {
            throw new Error("A node Icon must exist for all types of node");
        }
        const nodeType = getNodeTypeFromDmnObject(drgElement);
        if (nodeType === undefined) {
            throw new Error("Can't determine node icon with undefined node type");
        }
        return NodeIcon({ nodeType, isAlternativeInputDataShape });
    }, [drgElement, isAlternativeInputDataShape]);
    const onConfirmExpressionRefactor = useCallback(() => {
        if (!variableChangedArgs) {
            throw new Error("Can not update variable name because 'variableChangedArgs' is not set in the BoxedExpressionScreen.");
        }
        refactor();
        setVariableChangedArgs(undefined);
        setNewExpression(undefined);
        setIsRefactorModalOpen(false);
    }, [refactor, variableChangedArgs]);
    const onConfirmRenameOnly = useCallback(() => {
        setVariableChangedArgs(undefined);
        setNewExpression(undefined);
        setIsRefactorModalOpen(false);
        dmnEditorStoreApi.setState((state) => {
            setExpression({ definitions: state.dmn.model.definitions, expression: newExpression });
        });
    }, [dmnEditorStoreApi, newExpression, setExpression]);
    return (_jsx(_Fragment, { children: _jsxs(_Fragment, { children: [_jsxs(Flex, { className: "kie-dmn-editor--sticky-top-glass-header kie-dmn-editor--boxed-expression-header", justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" }, direction: { default: "row" }, children: [_jsx(FlexItem, { children: _jsxs(Label, { className: "kie-dmn-editor--boxed-expression-back", onClick: () => {
                                    dmnEditorStoreApi.setState((state) => {
                                        state.dispatch(state).boxedExpressionEditor.close();
                                    });
                                }, children: [_jsx(ArrowRightIcon, { style: { transform: "scale(-1, -1)", marginRight: "12px" } }), _jsx("p", { children: "Back to Diagram" })] }) }), _jsx(FlexItem, { children: _jsxs(Flex, { flexWrap: { default: "nowrap" }, justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" }, children: [_jsx(FlexItem, { children: _jsx("div", { style: { height: "40px", width: "40px" }, children: _jsx(Icon, {}) }) }), _jsx(FlexItem, { children: _jsx(TextContent, { children: _jsx(Text, { component: TextVariants.h2, children: expression === null || expression === void 0 ? void 0 : expression.drgElement["@_name"] }) }) }), _jsx(FlexItem, { style: { width: "105px" } })] }) }), _jsxs(Flex, { children: [_jsx(EvaluationHighlightsBadge, {}), _jsx("aside", { className: "kie-dmn-editor--properties-panel-toggle", style: { visibility: isPropertiesPanelOpen ? "hidden" : undefined }, children: _jsx("button", { className: "kie-dmn-editor--properties-panel-toggle-button", title: "Properties panel", onClick: () => {
                                            dmnEditorStoreApi.setState((state) => {
                                                state.boxedExpressionEditor.propertiesPanel.isOpen =
                                                    !state.boxedExpressionEditor.propertiesPanel.isOpen;
                                            });
                                        }, children: _jsx(InfoIcon, { size: "sm" }) }) })] })] }), _jsx(RefactorConfirmationDialog, { onConfirmExpressionRefactor: onConfirmExpressionRefactor, onConfirmRenameOnly: onConfirmRenameOnly, isRefactorModalOpen: isRefactorModalOpen, fromName: (_a = variableChangedArgs === null || variableChangedArgs === void 0 ? void 0 : variableChangedArgs.nameChange) === null || _a === void 0 ? void 0 : _a.from, toName: (_b = variableChangedArgs === null || variableChangedArgs === void 0 ? void 0 : variableChangedArgs.nameChange) === null || _b === void 0 ? void 0 : _b.to, onCancel: () => {
                        setIsRefactorModalOpen(false);
                        setVariableChangedArgs(undefined);
                        setNewExpression(undefined);
                    } }), _jsx("div", { style: { flexGrow: 1 }, children: _jsx(BoxedExpressionEditor, { beeGwtService: beeGwtService, pmmlDocuments: pmmlDocuments, isResetSupportedOnRootExpression: isResetSupportedOnRootExpression, expressionHolderId: activeDrgElementId, expressionHolderName: (_e = (_d = (_c = drgElement === null || drgElement === void 0 ? void 0 : drgElement.variable) === null || _c === void 0 ? void 0 : _c["@_name"]) !== null && _d !== void 0 ? _d : drgElement === null || drgElement === void 0 ? void 0 : drgElement["@_name"]) !== null && _e !== void 0 ? _e : "", expressionHolderTypeRef: (_g = (_f = drgElement === null || drgElement === void 0 ? void 0 : drgElement.variable) === null || _f === void 0 ? void 0 : _f["@_typeRef"]) !== null && _g !== void 0 ? _g : (_h = expression === null || expression === void 0 ? void 0 : expression.boxedExpression) === null || _h === void 0 ? void 0 : _h["@_typeRef"], expression: expression === null || expression === void 0 ? void 0 : expression.boxedExpression, onExpressionChange: onExpressionChange, dataTypes: dataTypes, scrollableParentRef: container, onRequestFeelIdentifiers: onRequestFeelIdentifiers, widthsById: widthsById, onWidthsChange: onWidthsChange, isReadOnly: settings.isReadOnly, evaluationHitsCountById: isEvaluationHighlightsEnabled
                            ? (_j = evaluationResultsByNodeId === null || evaluationResultsByNodeId === void 0 ? void 0 : evaluationResultsByNodeId.get(activeDrgElementId !== null && activeDrgElementId !== void 0 ? activeDrgElementId : "")) === null || _j === void 0 ? void 0 : _j.evaluationHitsCountByRuleOrRowId
                            : undefined }) })] }) }));
}
export function drgElementToBoxedExpression(expressionHolder) {
    var _a, _b, _c, _d, _e, _f, _g;
    if (expressionHolder.__$$element === "businessKnowledgeModel") {
        return expressionHolder.encapsulatedLogic
            ? {
                __$$element: "functionDefinition",
                "@_label": (_a = expressionHolder.encapsulatedLogic["@_label"]) !== null && _a !== void 0 ? _a : expressionHolder["@_name"],
                "@_typeRef": (_b = expressionHolder.encapsulatedLogic["@_typeRef"]) !== null && _b !== void 0 ? _b : (_c = expressionHolder.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"],
                ...expressionHolder.encapsulatedLogic,
            }
            : {
                __$$element: "functionDefinition",
                "@_id": generateUuid(),
                "@_kind": "FEEL",
                expression: undefined,
                formalParameter: [],
                "@_label": expressionHolder["@_name"],
                "@_typeRef": (_d = expressionHolder.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"],
            };
    }
    else if (expressionHolder.__$$element === "decision") {
        return expressionHolder.expression
            ? {
                ...expressionHolder.expression,
                "@_label": (_g = (_f = (_e = expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable) === null || _e === void 0 ? void 0 : _e["@_name"]) !== null && _f !== void 0 ? _f : expressionHolder.expression["@_label"]) !== null && _g !== void 0 ? _g : expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder["@_name"],
                "@_typeRef": (expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable)
                    ? expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable["@_typeRef"]
                    : expressionHolder.expression["@_typeRef"],
            }
            : undefined;
    }
    else {
        throw new Error(`Unknown __$$element of expressionHolder that has an expression '${expressionHolder.__$$element}'.`);
    }
}
function determineInputsForDecision(decision, allTopLevelDataTypesByFeelName, nodesById) {
    var _a;
    try {
        const ret = ((_a = decision.informationRequirement) !== null && _a !== void 0 ? _a : []).flatMap((s) => {
            var _a, _b, _c, _d, _e;
            const dmnObject = nodesById.get(((_b = (_a = s.requiredDecision) === null || _a === void 0 ? void 0 : _a["@_href"]) !== null && _b !== void 0 ? _b : (_c = s.requiredInput) === null || _c === void 0 ? void 0 : _c["@_href"])).data.dmnObject;
            if (!((dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "inputData" || (dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "decision")) {
                throw new Error("DMN EDITOR: Information requirement can't ever point to anything other than an InputData or a Decision");
            }
            const dataType = allTopLevelDataTypesByFeelName.get(dmnObject.variable["@_typeRef"]);
            return dataType && isStruct(dataType.itemDefinition)
                ? ((_d = dataType.itemDefinition.itemComponent) !== null && _d !== void 0 ? _d : []).flatMap((ic) => flattenItemComponents({
                    itemDefinition: ic,
                    acc: dmnObject.variable["@_name"],
                }))
                : [
                    {
                        name: dmnObject.variable["@_name"],
                        typeRef: (_e = dmnObject.variable) === null || _e === void 0 ? void 0 : _e["@_typeRef"],
                    },
                ];
        });
        if (ret.length === 0) {
            return undefined;
        }
        return ret;
    }
    catch (e) {
        console.error(`DMN EDITOR: Error suggesting imports for root expression on '${decision["@_name"]}'.`, e);
        return undefined;
    }
}
function flattenItemComponents({ itemDefinition, acc, }) {
    var _a, _b;
    if (!isStruct(itemDefinition)) {
        return [
            {
                name: `${acc}.${itemDefinition["@_name"]}`,
                typeRef: (_a = itemDefinition.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text,
            },
        ];
    }
    return ((_b = itemDefinition.itemComponent) !== null && _b !== void 0 ? _b : []).flatMap((ic) => {
        return flattenItemComponents({ itemDefinition: ic, acc: `${acc}.${itemDefinition["@_name"]}` });
    });
}
export function getPmmlDocumentData(pmml) {
    const models = [];
    const document = new PMMLDocumentData(models);
    if (pmml.models) {
        pmml.models.forEach((model) => {
            const modelData = retrieveModelData(model);
            if (modelData) {
                models.push(modelData);
            }
        });
    }
    return document;
}
export function retrieveModelData(model) {
    const modelsTypes = [
        AnomalyDetectionModel,
        AssociationModel,
        BayesianNetworkModel,
        BaselineModel,
        ClusteringModel,
        GaussianProcessModel,
        GeneralRegressionModel,
        MiningModel,
        NaiveBayesModel,
        NearestNeighborModel,
        NeuralNetwork,
        RegressionModel,
        RuleSetModel,
        SequenceModel,
        Scorecard,
        SupportVectorMachineModel,
        TextModel,
        TimeSeriesModel,
        TreeModel,
    ];
    let modelData;
    for (const type of modelsTypes) {
        if (model instanceof type) {
            const modelFields = model.MiningSchema.MiningField.map((field) => new PMMLFieldData(field.name.toString(), field.usageType));
            modelData = new PMMLModelData(model.modelName == null ? "" : model.modelName, modelFields);
        }
    }
    return modelData;
}
//# sourceMappingURL=BoxedExpressionScreen.js.map