import * as React from "react";
import { DmnEditorProps } from "./DmnEditor";
import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
export type DmnEditorContextProviderProps = Pick<DmnEditorProps, "externalContextDescription" | "externalContextName" | "issueTrackerHref" | "model" | "onRequestToJumpToPath" | "onRequestToResolvePath" | "evaluationResultsByNodeId">;
export type DmnModelBeforeEditing = DmnLatestModel;
export type DmnEditorContextType = Pick<DmnEditorContextProviderProps, "externalContextDescription" | "externalContextName" | "issueTrackerHref" | "onRequestToJumpToPath" | "onRequestToResolvePath" | "evaluationResultsByNodeId"> & {
    dmnModelBeforeEditingRef: React.MutableRefObject<DmnModelBeforeEditing>;
    dmnEditorRootElementRef: React.RefObject<HTMLDivElement>;
};
export declare function useDmnEditor(): DmnEditorContextType;
export declare function DmnEditorContextProvider(props: React.PropsWithChildren<DmnEditorContextProviderProps>): JSX.Element;
//# sourceMappingURL=DmnEditorContext.d.ts.map