import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { TextEditor } from "./TextEditor";
export class TextEditorView {
    constructor(envelopeContext, initArgs) {
        this.envelopeContext = envelopeContext;
        this.initArgs = initArgs;
        this.af_isReact = true;
        this.editorRef = React.createRef();
    }
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        return this.editorRef.current.setContent(normalizedPosixPathRelativeToTheWorkspaceRoot, content);
    }
    getContent() {
        return this.editorRef.current.getContent();
    }
    getPreview() {
        return this.editorRef.current.getPreview();
    }
    af_componentRoot() {
        return (_jsx(TextEditor, { ref: this.editorRef, isReadOnly: this.initArgs.isReadOnly, channelType: this.initArgs.channel, onNewEdit: this.envelopeContext.channelApi.notifications.kogitoWorkspace_newEdit.send, onStateControlCommandUpdate: this.envelopeContext.channelApi.notifications.kogitoEditor_stateControlCommandUpdate.send, setNotifications: this.envelopeContext.channelApi.notifications.kogitoNotifications_setNotifications.send }));
    }
    async undo() {
        return this.editorRef.current.undo();
    }
    async redo() {
        return this.editorRef.current.redo();
    }
    async validate() {
        return this.editorRef.current.validate();
    }
    async setTheme(theme) {
        return this.editorRef.current.setTheme(theme);
    }
}
//# sourceMappingURL=TextEditorView.js.map