import { jsx as _jsx } from "react/jsx-runtime";
import React, { useMemo, useEffect, useImperativeHandle, useState } from "react";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { BallBeat } from "react-pure-loaders";
import { FormOpenedState } from "../../../api";
import ReactFormRenderer from "../ReactFormRenderer/ReactFormRenderer";
import HtmlFormRenderer from "../HtmlFormRenderer/HtmlFormRenderer";
import "../styles.css";
import { InternalFormDisplayerApiImpl } from "./apis";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const FormDisplayer = React.forwardRef(({ isEnvelopeConnectedToChannel, content, data, context, onOpenForm, ouiaId, ouiaSafe }, forwardedRef) => {
    const [source, setSource] = useState();
    const [resources, setResources] = useState();
    const [formData, setFormData] = useState();
    const [formApi, setFormApi] = useState({});
    const [isExecuting, setIsExecuting] = useState(false);
    const canDisplayForm = useMemo(() => isEnvelopeConnectedToChannel && !isExecuting && source && resources, [isEnvelopeConnectedToChannel, isExecuting, source, resources]);
    useEffect(() => {
        window.Form = {
            openForm: (config) => {
                const api = {};
                setFormApi(new InternalFormDisplayerApiImpl(api, config.onOpen));
                return api;
            },
        };
    }, []);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setSource(content.source);
            setResources(content.configuration.resources);
            setFormData(data);
        }
    }, [isEnvelopeConnectedToChannel, content, data]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel && formApi) {
            formApi.onOpen({
                data: formData,
                context: context,
            });
            setTimeout(() => {
                onOpenForm({
                    state: FormOpenedState.OPENED,
                    size: {
                        height: document.body.scrollHeight,
                        width: document.body.scrollWidth,
                    },
                });
            }, 500);
        }
    }, [formApi]);
    useImperativeHandle(forwardedRef, () => formApi, [formApi]);
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "form-displayer", ouiaSafe), children: canDisplayForm ? (_jsx("div", { id: "inner-form-container", children: content.formInfo && content.formInfo.type === "TSX" ? (_jsx(ReactFormRenderer, { source: source, resources: resources, setIsExecuting: setIsExecuting })) : (_jsx(HtmlFormRenderer, { source: source, resources: resources })) })) : (_jsx(Bullseye, { className: "kogito-form-displayer__ball-beats", children: _jsx(BallBeat, { color: "#000000", loading: !isEnvelopeConnectedToChannel }) })) }));
});
export default FormDisplayer;
//# sourceMappingURL=FormDisplayer.js.map