import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useRef, useEffect, useImperativeHandle } from "react";
import { AutoRow } from "./uniforms/AutoRow";
import { createPortal } from "react-dom";
import { context as UniformsContext } from "uniforms";
import { AUTO_ROW_ID } from "./uniforms";
import { DmnAutoFieldProvider } from "@kie-tools/dmn-runner/dist/uniforms/DmnAutoFieldProvider";
import { unitablesDmnRunnerAutoFieldValue } from "./uniforms/UnitablesDmnRunnerAutoFieldValue";
export const UnitablesRow = React.forwardRef(({ children, formsId, rowIndex, jsonSchemaBridge, rowInput, onSubmitRow }, forwardRef) => {
    const autoRowRef = useRef(null);
    const onSubmit = useCallback((rowInput) => {
        console.debug("DMN RUNNER TABLE: submit row: ", rowIndex);
        onSubmitRow(rowInput, rowIndex, {});
    }, [onSubmitRow, rowIndex]);
    const onValidate = useCallback((inputs, error) => {
        return null;
    }, []);
    useImperativeHandle(forwardRef, () => {
        return {
            submit: () => { var _a; return (_a = autoRowRef.current) === null || _a === void 0 ? void 0 : _a.submit(); },
        };
    }, []);
    useEffect(() => {
        var _a;
        (_a = autoRowRef.current) === null || _a === void 0 ? void 0 : _a.submit();
    }, [autoRowRef]);
    return (_jsx(_Fragment, { children: _jsx(AutoRow, { ref: autoRowRef, schema: jsonSchemaBridge, model: rowInput, onSubmit: onSubmit, placeholder: true, validate: "onSubmit", onValidate: onValidate, children: _jsx(UniformsContext.Consumer, { children: (uniformsContext) => (_jsxs(_Fragment, { children: [createPortal(_jsx("form", { id: `${AUTO_ROW_ID}-${rowIndex}`, onSubmit: (data) => uniformsContext === null || uniformsContext === void 0 ? void 0 : uniformsContext.onSubmit(data) }), document.getElementById(formsId)), _jsx(DmnAutoFieldProvider, { value: unitablesDmnRunnerAutoFieldValue, children: children })] })) }) }) }));
});
//# sourceMappingURL=UnitablesRow.js.map