import { jsx as _jsx } from "react/jsx-runtime";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { WorkflowInstanceIconCreator } from "../utils/WorkflowListUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ErrorPopover = ({ workflowInstanceData, onSkipClick, onRetryClick, ouiaId, ouiaSafe, }) => {
    var _a;
    return (_jsx(Popover, { zIndex: 300, id: workflowInstanceData.id, headerContent: _jsx("div", { children: "Workflow error" }), bodyContent: _jsx("div", { children: workflowInstanceData.error ? workflowInstanceData.error.message : "No error message found" }), footerContent: ((_a = workflowInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
            workflowInstanceData.serviceUrl && [
            _jsx(Button, { id: "skip-button", variant: "secondary", onClick: () => onSkipClick(workflowInstanceData), className: "pf-u-mr-sm", children: "Skip" }, "confirm1"),
            _jsx(Button, { variant: "secondary", id: "retry-button", onClick: () => onRetryClick(workflowInstanceData), className: "pf-u-mr-sm", children: "Retry" }, "confirm2"),
        ], position: "auto", ...componentOuiaProps(ouiaId, "error-popover", ouiaSafe), children: _jsx(Button, { variant: "link", isInline: true, children: WorkflowInstanceIconCreator(workflowInstanceData.state) }) }));
};
export default ErrorPopover;
//# sourceMappingURL=ErrorPopover.js.map