import { jsx as _jsx } from "react/jsx-runtime";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const DisablePopup = ({ workflowInstanceData, component, ouiaId, ouiaSafe, }) => {
    var _a, _b, _c;
    let content = "";
    if (!((_a = workflowInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) && workflowInstanceData.serviceUrl === null) {
        content =
            "Management add-on capability not enabled & missing the kogito.service.url property. Contact your administrator to set up.";
    }
    else if (workflowInstanceData.serviceUrl === null && ((_b = workflowInstanceData.addons) === null || _b === void 0 ? void 0 : _b.includes("workflow-management"))) {
        content = "This Kogito runtime is missing the kogito.service.url property. Contact your administrator to set up.";
    }
    else if (!((_c = workflowInstanceData.addons) === null || _c === void 0 ? void 0 : _c.includes("workflow-management")) &&
        workflowInstanceData.serviceUrl !== null) {
        content = "Management add-on capability not enabled. Contact your administrator to set up";
    }
    return (_jsx(Tooltip, { content: "Unavailable", ...componentOuiaProps(ouiaId, "disable-popup", ouiaSafe), children: component }));
};
export default DisablePopup;
//# sourceMappingURL=DisablePopup.js.map