import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { WorkflowFormEnvelopeView } from "./WorkflowFormEnvelopeView";
import { WorkflowFormEnvelopeApiImpl } from "./WorkflowFormEnvelopeApiImpl";
import "./styles.css";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-workflow-form-container";
            ReactDOM.render(_jsx(WorkflowFormEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new WorkflowFormEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=WorkflowFormEnvelope.js.map