import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { WorkflowDetailsChannelApi, WorkflowDetailsDriver } from "../api";
import { TriggerableNode, NodeInstance } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { Job, JobCancel, WorkflowInstance } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export default class WorkflowDetailsEnvelopeViewDriver implements WorkflowDetailsDriver {
    private readonly channelApi;
    constructor(channelApi: MessageBusClientApi<WorkflowDetailsChannelApi>);
    handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobCancel>;
    rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    getTriggerableNodes(workflowInstance: WorkflowInstance): Promise<TriggerableNode[]>;
    handleNodeTrigger(workflowInstance: WorkflowInstance, node: TriggerableNode): Promise<void>;
    handleWorkflowVariableUpdate(workflowInstance: WorkflowInstance, updatedJson: Record<string, unknown>): Promise<Record<string, unknown>>;
    workflowDetailsQuery(id: string): Promise<WorkflowInstance>;
    jobsQuery(id: string): Promise<Job[]>;
    openWorkflowInstanceDetails(id: string): void;
    handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    handleNodeInstanceCancel(workflowInstance: WorkflowInstance, node: NodeInstance): Promise<void>;
    handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    handleNodeInstanceRetrigger(workflowInstance: WorkflowInstance, node: Pick<NodeInstance, "id">): Promise<void>;
}
//# sourceMappingURL=WorkflowDetailsEnvelopeViewDriver.d.ts.map