import { jsx as _jsx } from "react/jsx-runtime";
import React, { useImperativeHandle, useState } from "react";
import WorkflowDefinitionList from "./components/WorkflowDefinitionList/WorkflowDefinitionList";
import WorkflowDefinitionListEnvelopeViewDriver from "./WorkflowDefinitionListEnvelopeViewDriver";
export const WorkflowDefinitionListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(WorkflowDefinitionList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new WorkflowDefinitionListEnvelopeViewDriver(props.channelApi) }) }));
});
export default WorkflowDefinitionListEnvelopeView;
//# sourceMappingURL=WorkflowDefinitionListEnvelopeView.js.map