import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import Moment from "react-moment";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const JobsDetailsModal = ({ actionType, modalTitle, isModalOpen, modalAction, handleModalToggle, job, ouiaId, ouiaSafe, }) => {
    const modalContent = () => {
        return (_jsx("div", { className: "kogito-management-console-shared--jobsModal__detailsModal", children: _jsx(TextContent, { children: _jsxs(Flex, { direction: { default: "column" }, children: [_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Workflow Id: " }), " "] }), _jsx(SplitItem, { children: job.workflowId })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [" ", _jsx(Text, { component: TextVariants.h6, children: "Workflow Instance Id: " }), " "] }), _jsx(SplitItem, { children: job.workflowInstanceId })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Status: " }), " "] }), _jsx(SplitItem, { children: job.status })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Priority: " }), " "] }), _jsx(SplitItem, { children: job.priority })] }) }), job.repeatInterval && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "RepeatInterval: " }) }), _jsx(SplitItem, { children: job.repeatInterval })] }) })), job.repeatLimit && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "RepeatLimit: " }) }), _jsx(SplitItem, { children: job.repeatLimit })] }) })), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "ScheduledId: " }) }), _jsx(SplitItem, { children: job.scheduledId })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Retries: " }) }), _jsx(SplitItem, { children: job.retries })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Execution counter: " }) }), _jsx(SplitItem, { children: job.executionCounter })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Last Updated: " }) }), _jsx(SplitItem, { children: _jsx(Moment, { fromNow: true, children: new Date(`${job.lastUpdate}`) }) })] }) }), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsxs(Text, { component: TextVariants.h6, className: "kogito-management-console-shared--jobsModal__text", children: ["Callback Endpoint:", " "] }) }), _jsx(SplitItem, { children: job.callbackEndpoint })] }) })] }) }) }));
    };
    return (_jsx(Modal, { variant: "large", "aria-labelledby": actionType + "modal", "aria-label": actionType + "modal", title: "", header: modalTitle, isOpen: isModalOpen, onClose: handleModalToggle, actions: modalAction, ...componentOuiaProps(ouiaId, "job-details-modal", ouiaSafe), children: modalContent() }));
};
//# sourceMappingURL=JobsDetailsModal.js.map