import { EditorContent, EditorTheme, KogitoEditorChannelApi, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { MessageBusClientApi, SharedValueProvider } from "@kie-tools-core/envelope-bus/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { ResourceContent, ResourceContentRequest, ResourceListRequest, ResourcesList, WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { ServerlessWorkflowDiagramEditorChannelApi } from "@kie-tools/serverless-workflow-diagram-editor-envelope/dist/api";
import { ServerlessWorkflowTextEditorEnvelopeApi } from "@kie-tools/serverless-workflow-text-editor/dist/api";
export declare class ServerlessWorkflowDiagramEditorChannelApiImpl implements ServerlessWorkflowDiagramEditorChannelApi {
    private readonly args;
    constructor(args: {
        defaultApiImpl: KogitoEditorChannelApi;
        textEditorEnvelopeApi?: MessageBusClientApi<ServerlessWorkflowTextEditorEnvelopeApi>;
    });
    kogitoEditor_contentRequest(): Promise<EditorContent>;
    kogitoEditor_ready(): void;
    kogitoEditor_setContentError(content: EditorContent): void;
    kogitoEditor_stateControlCommandUpdate(command: StateControlCommand): void;
    kogitoI18n_getLocale(): Promise<string>;
    kogitoNotifications_createNotification(notification: Notification): void;
    kogitoNotifications_removeNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoNotifications_setNotifications(normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]): void;
    kogitoWorkspace_newEdit(edit: WorkspaceEdit): void;
    kogitoWorkspace_openFile(normalizedPosixPathRelativeToTheWorkspaceRoot: string): void;
    kogitoWorkspace_resourceContentRequest(request: ResourceContentRequest): Promise<ResourceContent | undefined>;
    kogitoWorkspace_resourceListRequest(request: ResourceListRequest): Promise<ResourcesList>;
    kogitoEditor_theme(): SharedValueProvider<EditorTheme>;
    kogitoSwfDiagramEditor__onNodeSelected(args: {
        nodeName: string;
        documentUri?: string;
    }): void;
    kogitoSwfDiagramEditor__setContentSuccess(): void;
}
//# sourceMappingURL=ServerlessWorkflowDiagramEditorChannelApiImpl.d.ts.map