export declare const DASHBUILDER_SCHEMA: {
    $id: string;
    $schema: string;
    description: string;
    type: string;
    properties: {
        pages: {
            description: string;
            type: string;
            items: {
                $ref: string;
            };
        };
        datasets: {
            type: string;
            description: string;
            items: {
                $ref: string;
            };
        };
        navTree: {
            description: string;
            $ref: string;
        };
        properties: {
            description: string;
            $ref: string;
        };
        global: {
            description: string;
            $ref: string;
        };
    };
    required: string[];
    definitions: {
        GlobalProperties: {
            type: string;
            properties: {
                mode: {
                    description: string;
                    $ref: string;
                };
                allowUrlProperties: {
                    type: string[];
                };
                displayer: {
                    description: string;
                    $ref: string;
                };
                dataset: {
                    description: string;
                    $ref: string;
                };
            };
            title: string;
        };
        Page: {
            type: string;
            properties: {
                name: {
                    description: string;
                    type: string;
                };
                components: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                rows: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                properties: {
                    description: string;
                    $ref: string;
                };
            };
            title: string;
        };
        PageComponent: {
            type: string;
            description: string;
            properties: {
                html: {
                    description: string;
                    type: string;
                };
                markdown: {
                    description: string;
                    type: string;
                };
                panel: {
                    description: string;
                    type: string;
                };
                screen: {
                    description: string;
                    type: string;
                };
                displayer: {
                    description: string;
                    $ref: string;
                };
            };
            title: string;
        };
        Row: {
            type: string;
            description: string;
            properties: {
                columns: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                properties: {
                    description: string;
                    $ref: string;
                };
            };
            required: string[];
            title: string;
        };
        RowColumn: {
            type: string;
            description: string;
            properties: {
                span: {
                    description: string;
                    type: string[];
                };
                components: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                rows: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                properties: {
                    $ref: string;
                };
            };
            required: string[];
            title: string;
        };
        ColumnComponent: {
            $ref: string;
        };
        Dataset: {
            type: string;
            properties: {
                uuid: {
                    description: string;
                    type: string;
                };
                url: {
                    description: string;
                    type: string;
                    format: string;
                };
                type: {
                    description: string;
                    $ref: string;
                };
                content: {
                    description: string;
                    type: string;
                };
                columns: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                expression: {
                    description: string;
                    type: string;
                    minLength: number;
                };
                cacheEnabled: {
                    description: string;
                    type: string[];
                };
                refreshTime: {
                    description: string;
                    type: string;
                };
                maxCacheRows: {
                    description: string;
                    type: string;
                };
                path: {
                    description: string;
                    type: string;
                };
                method: {
                    description: string;
                    type: string;
                };
                accumulate: {
                    description: string;
                    type: string;
                };
                headers: {
                    description: string;
                    $ref: string;
                };
                query: {
                    description: string;
                    $ref: string;
                };
                form: {
                    description: string;
                    $ref: string;
                };
            };
            oneOf: {
                properties: {
                    content: {
                        type: string;
                    };
                    url: {
                        type: string;
                        format: string;
                    };
                    join: {
                        type: string;
                    };
                };
                required: string[];
                not: {
                    required: string[];
                };
            }[];
            required: string[];
            title: string;
        };
        typeEnum: {
            type: string;
            description: string;
            enum: string[];
            additionalProperties: boolean;
            title: string;
        };
        DatasetColumn: {
            type: string;
            properties: {
                id: {
                    description: string;
                    type: string;
                };
                type: {
                    $ref: string;
                };
            };
            required: string[];
            title: string;
        };
        DataSetLookup: {
            type: string;
            description: string;
            properties: {
                uuid: {
                    description: string;
                    type: string;
                };
                rowCount: {
                    description: string;
                    type: string;
                };
                rowOffset: {
                    description: string;
                    type: string;
                };
                sort: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                filter: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
                group: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
            };
            required: string[];
            title: string;
        };
        SettingsFilter: {
            type: string;
            properties: {
                enabled: {
                    type: string[];
                };
                listening: {
                    description: string;
                    type: string[];
                };
                notification: {
                    description: string;
                    type: string[];
                };
                selfapply: {
                    description: string;
                    type: string[];
                };
            };
            title: string;
        };
        SettingsColumn: {
            description: string;
            type: string;
            properties: {
                id: {
                    description: string;
                    type: string;
                };
                name: {
                    description: string;
                    type: string;
                };
                expression: {
                    description: string;
                    type: string;
                };
                pattern: {
                    description: string;
                    type: string;
                };
            };
            required: string[];
            title: string;
        };
        SettingsHTML: {
            type: string;
            description: string;
            properties: {
                html: {
                    description: string;
                    type: string;
                };
                javascript: {
                    description: string;
                    type: string;
                };
            };
            title: string;
        };
        SettingsTable: {
            type: string;
            properties: {
                pageSize: {
                    description: string;
                    type: string;
                };
                show_column_picker: {
                    description: string;
                    type: string;
                };
                sort: {
                    $ref: string;
                };
            };
            title: string;
        };
        TableSort: {
            type: string;
            description: string;
            properties: {
                enabled: {
                    type: string[];
                };
                columnId: {
                    type: string;
                };
                order: {
                    $ref: string;
                };
            };
            required: string[];
            title: string;
        };
        Sort: {
            type: string;
            properties: {
                column: {
                    type: string;
                };
                order: {
                    $ref: string;
                };
            };
            required: string[];
            title: string;
        };
        sortEnum: {
            type: string;
            enum: string[];
            additionalProperties: boolean;
            title: string;
        };
        FilterComponent: {
            type: string;
            description: string;
            properties: {
                column: {
                    description: string;
                    type: string;
                };
                function: {
                    description: string;
                    $ref: string;
                };
                args: {
                    description: string;
                    type: string;
                };
            };
            required: string[];
            allOf: {
                if: {
                    properties: {
                        function: {
                            const: string;
                        };
                    };
                };
                then: {
                    properties: {
                        args: {
                            type: string;
                            items: {
                                $ref: string;
                            };
                        };
                    };
                };
            }[];
            title: string;
        };
        DatasetlookupGroup: {
            type: string;
            properties: {
                columnGroup: {
                    description: string;
                    type: string;
                    properties: {
                        source: {
                            description: string;
                            type: string;
                        };
                    };
                    required: string[];
                };
                functions: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
            };
            title: string;
        };
        ColumnGroupFunctions: {
            type: string;
            description: string;
            properties: {
                source: {
                    description: string;
                    type: string;
                };
                function: {
                    type: string;
                    enum: string[];
                    additionalProperties: boolean;
                };
                column: {
                    description: string;
                    type: string;
                };
            };
            required: string[];
            title: string;
        };
        NavTree: {
            type: string;
            description: string;
            properties: {
                root_items: {
                    description: string;
                    type: string;
                    items: {
                        $ref: string;
                    };
                };
            };
            required: string[];
            title: string;
        };
        RootItem: {
            type: string;
            description: string;
            properties: {
                type: {
                    description: string;
                    $ref: string;
                };
                id: {
                    type: string;
                };
                name: {
                    type: string;
                };
                children: {
                    type: string;
                    description: string;
                    items: {
                        $ref: string;
                    };
                };
            };
            title: string;
        };
        Child: {
            type: string;
            properties: {
                page: {
                    type: string;
                };
            };
            title: string;
        };
        NavItemEnum: {
            type: string;
            enum: string[];
            title: string;
        };
        DataSetType: {
            type: string;
            enum: string[];
            title: string;
        };
        FunctionList: {
            type: string;
            enum: string[];
            title: string;
        };
        ChartProperties: {
            type: string;
            properties: {
                bgColor: {
                    description: string;
                    type: string;
                };
                width: {
                    description: string;
                    type: string[];
                };
                height: {
                    description: string;
                    type: string[];
                };
                zoom: {
                    description: string;
                    type: string[];
                };
                margin: {
                    type: string;
                    description: string;
                    properties: {
                        right: {
                            type: string[];
                        };
                        top: {
                            type: string[];
                        };
                        bottom: {
                            type: string[];
                        };
                        left: {
                            type: string[];
                        };
                    };
                };
                resizable: {
                    description: string;
                    type: string[];
                };
                legend: {
                    type: string;
                    description: string;
                    properties: {
                        show: {
                            description: string;
                            type: string[];
                        };
                        position: {
                            type: string;
                            description: string;
                            enum: string[];
                        };
                    };
                };
                grid: {
                    type: string;
                    description: string;
                    properties: {
                        x: {
                            type: string[];
                        };
                        y: {
                            type: string[];
                        };
                    };
                };
            };
        };
        CustomProperties: {
            type: string;
            description: string;
            additionalProperties: {};
        };
        DatasetHeaders: {
            type: string;
            description: string;
            additionalProperties: {};
        };
        DatasetQuery: {
            type: string;
            description: string;
            additionalProperties: {};
        };
        DatasetForm: {
            type: string;
            description: string;
            additionalProperties: {};
        };
        DisplayerSettings: {
            type: string;
            properties: {
                lookup: {
                    description: string;
                    $ref: string;
                };
                dataSet: {
                    description: string;
                    type: string;
                };
                filter: {
                    $ref: string;
                };
                refresh: {
                    type: string;
                    description: string;
                    properties: {
                        interval: {
                            description: string;
                            type: string;
                        };
                    };
                    required: string[];
                    title: string;
                };
                renderer: {
                    type: string;
                    description: string;
                    enum: string[];
                    additionalProperties: boolean;
                    title: string;
                };
                extraConfiguration: {
                    type: string;
                    description: string;
                };
                selector: {
                    type: string;
                    properties: {
                        multiple: {
                            type: string[];
                        };
                        inputs_show: {
                            type: string[];
                        };
                    };
                    required: string[];
                    title: string;
                };
                general: {
                    type: string;
                    properties: {
                        visible: {
                            description: string;
                            type: string[];
                        };
                        title: {
                            description: string;
                            type: string;
                        };
                        subtitle: {
                            description: string;
                            type: string;
                        };
                        mode: {
                            $ref: string;
                        };
                        allowEdit: {
                            type: string;
                            title: string;
                        };
                    };
                    required: string[];
                    title: string;
                };
                export: {
                    type: string;
                    description: string;
                    properties: {
                        png: {
                            description: string;
                            type: string;
                        };
                    };
                    required: string[];
                    title: string;
                };
                columns: {
                    type: string;
                    items: {
                        $ref: string;
                    };
                };
                table: {
                    $ref: string;
                };
                html: {
                    $ref: string;
                };
                map: {
                    type: string;
                    properties: {
                        color_scheme: {
                            $ref: string;
                        };
                    };
                    title: string;
                };
                meter: {
                    $ref: string;
                };
                component: {
                    anyOf: ({
                        type: string;
                        $ref?: undefined;
                    } | {
                        $ref: string;
                        type?: undefined;
                    })[];
                };
                external: {
                    description: string;
                    $ref: string;
                };
                bubble: {
                    type: string;
                    description: string;
                    properties: {
                        minSize: {
                            description: string;
                            type: string;
                        };
                        maxSize: {
                            description: string;
                            type: string;
                        };
                        color: {
                            description: string;
                            type: string;
                        };
                    };
                    required: string[];
                    title: string;
                };
                axis: {
                    type: string;
                    properties: {
                        x: {
                            type: string;
                            description: string;
                            properties: {
                                labels_show: {
                                    description: string;
                                    type: string[];
                                };
                                title: {
                                    description: string;
                                    type: string;
                                };
                                labels_angle: {
                                    description: string;
                                    type: string[];
                                };
                            };
                            title: string;
                        };
                        y: {
                            type: string;
                            properties: {
                                labels_show: {
                                    description: string;
                                    type: string[];
                                };
                                title: {
                                    description: string;
                                    type: string;
                                };
                                labels_angle: {
                                    description: string;
                                    type: string[];
                                };
                            };
                            title: string;
                        };
                    };
                };
                type: {
                    $ref: string;
                };
                chart: {
                    $ref: string;
                };
            };
            allOf: {
                if: {
                    properties: {
                        type: {
                            const: string;
                        };
                    };
                };
                then: {
                    properties: {
                        subtype: {
                            $ref: string;
                        };
                    };
                };
            }[];
            title: string;
        };
        SettingsExternal: {
            type: string;
            properties: {
                baseUrl: {
                    type: string;
                };
                width: {};
                height: {};
            };
            title: string;
        };
        ChartType: {
            type: string;
            enum: string[];
            additionalProperties: boolean;
            title: string;
        };
        BarChartTypes: {
            type: string;
            enum: string[];
            default: string;
            additionalProperties: boolean;
            title: string;
        };
        LineChartTypes: {
            type: string;
            enum: string[];
            default: string;
            additionalProperties: boolean;
            title: string;
        };
        AreaChartTypes: {
            type: string;
            enum: string[];
            default: string;
            additionalProperties: boolean;
            title: string;
        };
        PieChartTypes: {
            type: string;
            enum: string[];
            default: string;
            additionalProperties: boolean;
            title: string;
        };
        SelectorTypes: {
            type: string;
            enum: string[];
            additionalProperties: boolean;
            title: string;
        };
        MeterTypes: {
            type: string;
            properties: {
                start: {
                    type: string;
                };
                end: {
                    type: string;
                };
                critical: {
                    type: string;
                };
                warning: {
                    type: string;
                };
            };
        };
        MapColorScheme: {
            type: string;
            enum: string[];
        };
        MapTypes: {
            type: string;
            enum: string[];
            additionalProperties: boolean;
        };
        NavComponentTypes: {
            type: string;
            enum: string[];
            additionalProperties: boolean;
        };
        SettingsComponent: {
            type: string;
            enum: string[];
        };
        ColourModes: {
            type: string;
            enum: string[];
            title: string;
            additionalProperties: boolean;
        };
    };
};
//# sourceMappingURL=dashbuilder.d.ts.map