import * as React from "react";
import * as ReactTable from "react-table";
import { ResizingWidth } from "./ResizingWidthsContext";
export declare function useFillingResizingWidth(columnIndex: number, column: ReactTable.ColumnInstance<any>, reactTableInstance: ReactTable.TableInstance<any>, shouldRenderRowIndexColumn: boolean): {
    fillingResizingWidth: {
        isPivoting: boolean;
        value: number;
    };
    setFillingResizingWidth: React.Dispatch<React.SetStateAction<{
        isPivoting: boolean;
        value: number;
    }>>;
    minFillingWidth: number;
    fillingWidth: number;
    setFillingWidth: (newWidth: number) => void;
};
export declare function sumColumnPropertyRecursively(column: ReactTable.ColumnInstance<any>, property: "width" | "minWidth", containerValue: number): number;
export declare function findIndexOfColumn(column: ReactTable.Column<any> | undefined, reactTableInstance: ReactTable.TableInstance<any>): number;
export declare function getTotalColumnResizingWidth(column: ReactTable.ColumnInstance<any>, columnResizingWidths: Map<number, ResizingWidth | undefined>, reactTableInstance: ReactTable.TableInstance<any>): {
    isPivoting: boolean;
    value: number;
};
export declare function getFlatListOfSubColumns(column: ReactTable.Column<any>): ReactTable.Column<any>[];
export declare function isParentColumn(column: ReactTable.Column<any>): boolean;
export declare function isFlexbileColumn(column: ReactTable.Column<any>): boolean;
export declare function computeNewSubColumnResizingWidths(args: {
    reactTableInstance: ReactTable.TableInstance<any>;
    column: ReactTable.ColumnInstance<any>;
    isPivoting: boolean;
    newTotalWidth: number;
}): Map<any, any>;
//# sourceMappingURL=FillingColumnResizingWidth.d.ts.map