import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect } from "react";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditor, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import "../ContextExpression/ContextEntryExpressionCell.css";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
export const ArgumentEntryExpressionCell = ({ data, rowIndex, columnIndex, parentElementId }) => {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const { expression, variable, index } = data[rowIndex];
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            expression ? beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(expression["@_id"]) : "";
        }
    }, [beeGwtService, columnIndex, expression, isActive]);
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c;
                const newBindings = [...((_a = prev.binding) !== null && _a !== void 0 ? _a : [])];
                newBindings[index] = {
                    ...newBindings[index],
                    expression: getNewExpression((_c = (_b = newBindings[index]) === null || _b === void 0 ? void 0 : _b.expression) !== null && _c !== void 0 ? _c : undefined),
                };
                const ret = {
                    ...prev,
                    binding: newBindings,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [index, setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: variable["@_typeRef"], parentElementName: variable["@_name"] }) }));
};
//# sourceMappingURL=ArgumentEntryExpressionCell.js.map