import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, BoxedFunctionKind, DmnBuiltInDataType, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { FEEL_FUNCTION_EXPRESSION_EXTRA_WIDTH, FEEL_FUNCTION_EXPRESSION_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditor, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { useFunctionExpressionControllerCell, useFunctionExpressionParametersColumnHeader } from "./FunctionExpression";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
import { findAllIdsDeep } from "../../ids/ids";
export function FeelFunctionExpression({ isNested, parentElementId, functionExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const parametersColumnHeader = useFunctionExpressionParametersColumnHeader(functionExpression.formalParameter, isReadOnly !== null && isReadOnly !== void 0 ? isReadOnly : false);
    const parametersId = useMemo(() => (functionExpression["@_id"] ? `${functionExpression["@_id"]}-parameters` : "parameters"), [functionExpression]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = functionExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = functionExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                width: undefined,
                columns: [
                    {
                        headerCellElement: parametersColumnHeader,
                        accessor: parametersId,
                        label: "parameters",
                        isRowIndexColumn: false,
                        dataType: undefined,
                        width: undefined,
                    },
                ],
            },
        ];
    }, [expressionHolderId, functionExpression, parametersColumnHeader, parametersId]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.LastLevel : BeeTableHeaderVisibility.AllLevels;
    }, [isNested]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        var _a, _b;
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: expressionHolderId,
            typeChange: typeRef !== functionExpression["@_typeRef"]
                ? {
                    from: (_a = functionExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "",
                    to: typeRef,
                }
                : undefined,
            nameChange: name !== functionExpression["@_label"]
                ? {
                    from: (_b = functionExpression["@_label"]) !== null && _b !== void 0 ? _b : "",
                    to: name,
                }
                : undefined,
        };
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_label": name,
                    "@_typeRef": typeRef,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [expressionHolderId, functionExpression, setExpression]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [{ name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy }],
            },
            {
                group: i18n.function.toUpperCase(),
                items: [{ name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset }],
            },
        ];
    }, [i18n]);
    const beeTableRows = useMemo(() => {
        return [{ functionExpression }];
    }, [functionExpression]);
    const controllerCell = useFunctionExpressionControllerCell(BoxedFunctionKind.Feel);
    const cellComponentByColumnAccessor = useMemo(() => {
        return {
            [`${parametersId}`]: (props) => _jsx(FeelFunctionImplementationCell, { ...props, parentElementId: parentElementId }),
        };
    }, [parentElementId, parametersId]);
    const getRowKey = useCallback((r) => {
        return r.id;
    }, []);
    const onRowReset = useCallback(() => {
        let oldExpression;
        setExpression({
            setExpressionAction: (prev) => {
                oldExpression = prev.expression;
                return undefined;
            },
            expressionChangedArgs: { action: Action.RowReset, rowIndex: 0 },
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [setExpression, setWidthsById]);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        var _a;
        const nestedExpressions = [(_a = functionExpression.expression) !== null && _a !== void 0 ? _a : undefined];
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: 0,
            fixedColumnResizingWidth: { value: 0, isPivoting: false },
            fixedColumnMinWidth: 0,
            nestedExpressionMinWidth: FEEL_FUNCTION_EXPRESSION_MIN_WIDTH,
            extraWidth: FEEL_FUNCTION_EXPRESSION_EXTRA_WIDTH,
            expression: functionExpression,
            flexibleColumnIndex: 1,
            widthsById: widthsById,
        };
    }, [functionExpression, widthsById]));
    const allowedOperations = useCallback((conditions) => {
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        return [
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.rowIndex >= 0 ? [BeeTableOperation.RowReset] : []),
        ];
    }, []);
    return (_jsx(NestedExpressionContainerContext.Provider, { value: nestedExpressionContainerValue, children: _jsx("div", { className: `function-expression ${functionExpression["@_id"]}`, children: _jsx(BeeTable, { isReadOnly: isReadOnly, onColumnResizingWidthChange: onColumnResizingWidthChange, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, onColumnUpdates: onColumnUpdates, getRowKey: getRowKey, onRowReset: onRowReset, columns: beeTableColumns, rows: beeTableRows, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: headerVisibility, controllerCell: controllerCell, cellComponentByColumnAccessor: cellComponentByColumnAccessor, shouldRenderRowIndexColumn: true, shouldShowRowsInlineControls: false, shouldShowColumnsInlineControls: false }) }) }));
}
export function FeelFunctionImplementationCell({ data, rowIndex, columnIndex, parentElementId, }) {
    var _a;
    const functionExpression = data[rowIndex].functionExpression;
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs, }) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const ret = {
                    ...prev,
                    expression: getNewExpression((_a = prev.expression) !== null && _a !== void 0 ? _a : undefined),
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: (_a = functionExpression.expression) !== null && _a !== void 0 ? _a : undefined, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: functionExpression["@_typeRef"], parentElementName: "Return" }) }));
}
//# sourceMappingURL=FeelFunctionExpression.js.map