import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, getNextAvailablePrefixedName, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH, CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX, CONTEXT_ENTRY_VARIABLE_MIN_WIDTH, CONTEXT_EXPRESSION_EXTRA_WIDTH, } from "../../resizing/WidthConstants";
import { useBeeTableCoordinates, useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { ContextEntryExpressionCell } from "./ContextEntryExpressionCell";
import { ExpressionVariableCell } from "../../expressionVariable/ExpressionVariableCell";
import { ContextResultExpressionCell } from "./ContextResultExpressionCell";
import { getExpressionTotalMinWidth } from "../../resizing/WidthMaths";
import { findAllIdsDeep } from "../../ids/ids";
import "./ContextExpression.css";
export function ContextExpression({ isNested, parentElementId, expression: contextExpression, }) {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const id = contextExpression["@_id"];
    const widths = useMemo(() => { var _a; return (_a = widthsById.get(id)) !== null && _a !== void 0 ? _a : []; }, [id, widthsById]);
    const getEntryVariableWidth = useCallback((widths) => { var _a; return (_a = widths === null || widths === void 0 ? void 0 : widths[CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX]) !== null && _a !== void 0 ? _a : CONTEXT_ENTRY_VARIABLE_MIN_WIDTH; }, []);
    const entryVariableWidth = useMemo(() => getEntryVariableWidth(widths), [getEntryVariableWidth, widths]);
    const setEntryVariableWidth = useCallback((newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(getEntryVariableWidth(prev)) : newWidthAction;
            if (newWidth) {
                const minSize = CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(CONTEXT_ENTRY_VARIABLE_MIN_WIDTH));
                newValues.splice(CONTEXT_ENTRY_VARIABLE_COLUMN_WIDTH_INDEX, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [getEntryVariableWidth, id, setWidthsById]);
    const [entryVariableResizingWidth, setEntryVariableResizingWidth] = useState({
        value: entryVariableWidth,
        isPivoting: false,
    });
    const onColumnResizingWidthChange1 = useCallback((args) => {
        const newResizingWidth = args.get(1);
        if (newResizingWidth) {
            setEntryVariableResizingWidth(newResizingWidth);
        }
    }, []);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange: onColumnResizingWidthChange2 } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        var _a;
        const nestedExpressions = ((_a = contextExpression.contextEntry) !== null && _a !== void 0 ? _a : []).map((e) => e.expression);
        const maxNestedExpressionTotalMinWidth = Math.max(...nestedExpressions.map((e) => getExpressionTotalMinWidth(0, e, widthsById)), CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH);
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: entryVariableWidth,
            fixedColumnResizingWidth: entryVariableResizingWidth,
            fixedColumnMinWidth: CONTEXT_ENTRY_VARIABLE_MIN_WIDTH,
            nestedExpressionMinWidth: maxNestedExpressionTotalMinWidth,
            extraWidth: CONTEXT_EXPRESSION_EXTRA_WIDTH,
            expression: contextExpression,
            flexibleColumnIndex: 2,
            widthsById: widthsById,
        };
    }, [contextExpression, entryVariableResizingWidth, entryVariableWidth, widthsById]));
    const onColumnResizingWidthChange = useCallback((args) => {
        onColumnResizingWidthChange2 === null || onColumnResizingWidthChange2 === void 0 ? void 0 : onColumnResizingWidthChange2(args);
        onColumnResizingWidthChange1(args);
    }, [onColumnResizingWidthChange1, onColumnResizingWidthChange2]);
    const beeTableColumns = useMemo(() => {
        var _a, _b;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = contextExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                isRowIndexColumn: false,
                dataType: (_b = contextExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                width: undefined,
                columns: [
                    {
                        accessor: "variable",
                        label: "variable",
                        isRowIndexColumn: false,
                        dataType: DmnBuiltInDataType.Undefined,
                        isWidthPinned: true,
                        minWidth: CONTEXT_ENTRY_VARIABLE_MIN_WIDTH,
                        width: entryVariableWidth,
                        setWidth: setEntryVariableWidth,
                    },
                    {
                        accessor: "expression",
                        label: "expression",
                        dataType: DmnBuiltInDataType.Undefined,
                        isRowIndexColumn: false,
                        minWidth: CONTEXT_ENTRY_EXPRESSION_MIN_WIDTH,
                        width: undefined,
                    },
                ],
            },
        ];
    }, [contextExpression, entryVariableWidth, expressionHolderId, setEntryVariableWidth]);
    const onColumnUpdates = useCallback(([{ name, typeRef }]) => {
        var _a, _b;
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: expressionHolderId,
            typeChange: typeRef !== contextExpression["@_typeRef"]
                ? {
                    from: (_a = contextExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "",
                    to: typeRef,
                }
                : undefined,
            nameChange: name !== contextExpression["@_label"]
                ? {
                    from: (_b = contextExpression["@_label"]) !== null && _b !== void 0 ? _b : "",
                    to: name,
                }
                : undefined,
        };
        setExpression({
            setExpressionAction: (prev) => {
                const ret = {
                    ...prev,
                    "@_label": name,
                    "@_typeRef": typeRef,
                };
                return ret;
            },
            expressionChangedArgs,
        });
    }, [contextExpression, expressionHolderId, setExpression]);
    const headerVisibility = useMemo(() => {
        return isNested ? BeeTableHeaderVisibility.None : BeeTableHeaderVisibility.SecondToLastLevel;
    }, [isNested]);
    const updateVariable = useCallback((index, { expression, variable }, variableChangedArgs) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const contextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
                contextEntries[index] = {
                    ...contextEntries[index],
                    expression: expression !== null && expression !== void 0 ? expression : undefined,
                    variable: variable,
                };
                const ret = {
                    ...prev,
                    contextEntry: contextEntries,
                };
                return ret;
            },
            expressionChangedArgs: variableChangedArgs,
        });
    }, [setExpression]);
    const cellComponentByColumnAccessor = useMemo(() => {
        return {
            variable: (props) => _jsx(ExpressionVariableCell, { ...props, onExpressionWithVariableUpdated: updateVariable }),
            expression: (props) => _jsx(ContextEntryExpressionCell, { ...props }),
        };
    }, [updateVariable]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.contextEntry,
                items: [
                    { name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset },
                    { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                    { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                    { name: i18n.insert, type: BeeTableOperation.RowInsertN },
                    { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
                ],
            },
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [
                    { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                    { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                    { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                    { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
                ],
            },
        ];
    }, [i18n]);
    const getRowKey = useCallback((row) => {
        return row.id;
    }, []);
    const beeTableAdditionalRow = useMemo(() => {
        var _a, _b;
        return [
            _jsx(ContextResultInfoCell, { parentElementId: parentElementId }, "context-result-info"),
            _jsx(ContextResultExpressionCell, { contextExpression: contextExpression, rowIndex: (_b = (_a = contextExpression.contextEntry) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 1, columnIndex: 2 }, "context-result-expression"),
        ];
    }, [contextExpression, parentElementId]);
    const getDefaultContextEntry = useCallback((name) => {
        var _a;
        const variableName = name ||
            getNextAvailablePrefixedName(((_a = contextExpression.contextEntry) !== null && _a !== void 0 ? _a : []).map((e) => { var _a, _b; return (_b = (_a = e.variable) === null || _a === void 0 ? void 0 : _a["@_name"]) !== null && _b !== void 0 ? _b : ""; }), "ContextEntry");
        return {
            "@_id": generateUuid(),
            expression: undefined,
            variable: {
                "@_id": generateUuid(),
                "@_name": variableName,
                "@_typeRef": undefined,
                description: { __$$text: "" },
            },
        };
    }, [contextExpression]);
    const onRowAdded = useCallback((args) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
                const newEntries = [];
                const names = newContextEntries.map((e) => { var _a, _b; return (_b = (_a = e.variable) === null || _a === void 0 ? void 0 : _a["@_name"]) !== null && _b !== void 0 ? _b : ""; }).filter((e) => e !== "");
                for (let i = 0; i < args.rowsCount; i++) {
                    const name = getNextAvailablePrefixedName(names, "ContextEntry");
                    names.push(name);
                    newEntries.push(getDefaultContextEntry(name));
                }
                for (const newEntry of newEntries) {
                    newContextEntries.splice(args.beforeIndex, 0, newEntry);
                }
                const ret = {
                    ...prev,
                    contextEntry: newContextEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowsAdded, rowIndex: args.beforeIndex, rowsCount: args.rowsCount },
        });
    }, [getDefaultContextEntry, setExpression]);
    const onRowDeleted = useCallback((args) => {
        let oldExpression;
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b;
                const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
                const { isResultOperation: isDeletingResult, entryIndex } = solveResultAndEntriesIndex({
                    contextEntries: newContextEntries,
                    rowIndex: args.rowIndex,
                });
                if (isDeletingResult) {
                    throw new Error("It's not possible to delete the <result> row");
                }
                else {
                    oldExpression = (_b = newContextEntries[entryIndex]) === null || _b === void 0 ? void 0 : _b.expression;
                    newContextEntries.splice(entryIndex, 1);
                }
                const ret = {
                    ...prev,
                    contextEntry: newContextEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowRemoved, rowIndex: args.rowIndex },
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [setExpression, setWidthsById]);
    const onRowReset = useCallback((args) => {
        let oldExpression;
        setExpression({
            setExpressionAction: (prev) => {
                var _a, _b, _c, _d, _e;
                const newContextEntries = [...((_a = prev.contextEntry) !== null && _a !== void 0 ? _a : [])];
                const { isResultOperation: isResettingResult, hasResultEntry: hasResultExpression, resultIndex, entryIndex, } = solveResultAndEntriesIndex({
                    contextEntries: newContextEntries,
                    rowIndex: args.rowIndex,
                });
                if (isResettingResult) {
                    if (hasResultExpression) {
                        oldExpression = (_b = newContextEntries[resultIndex]) === null || _b === void 0 ? void 0 : _b.expression;
                        newContextEntries.splice(resultIndex, 1);
                    }
                    else {
                    }
                }
                else {
                    oldExpression = (_c = newContextEntries[entryIndex]) === null || _c === void 0 ? void 0 : _c.expression;
                    const defaultContextEntry = getDefaultContextEntry((_e = (_d = newContextEntries[entryIndex]) === null || _d === void 0 ? void 0 : _d.variable) === null || _e === void 0 ? void 0 : _e["@_name"]);
                    newContextEntries.splice(entryIndex, 1, defaultContextEntry);
                }
                const ret = {
                    ...prev,
                    contextEntry: newContextEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowReset, rowIndex: args.rowIndex },
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [getDefaultContextEntry, setExpression, setWidthsById]);
    const allowedOperations = useCallback((conditions) => {
        var _a;
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        const columnIndex = conditions.selection.selectionStart.columnIndex;
        const rowIndex = conditions.selection.selectionStart.rowIndex;
        const contextEntries = (_a = contextExpression.contextEntry) !== null && _a !== void 0 ? _a : [];
        const { isResultOperation, hasResultEntry } = solveResultAndEntriesIndex({ contextEntries, rowIndex });
        const canDeleteEntry = !isResultOperation && (hasResultEntry ? contextEntries.length > 2 : contextEntries.length > 1);
        return [
            BeeTableOperation.SelectionCopy,
            ...(columnIndex > 1
                ? [BeeTableOperation.SelectionCut, BeeTableOperation.SelectionPaste, BeeTableOperation.SelectionReset]
                : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0
                ? [
                    BeeTableOperation.RowInsertAbove,
                    ...(!isResultOperation ? [BeeTableOperation.RowInsertBelow] : []),
                    ...(!isResultOperation ? [BeeTableOperation.RowInsertN] : []),
                    ...(canDeleteEntry ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                ]
                : []),
        ];
    }, [contextExpression.contextEntry]);
    const beeTableRows = useMemo(() => {
        var _a;
        return ((_a = contextExpression.contextEntry) !== null && _a !== void 0 ? _a : []).flatMap((contextEntry, i) => !contextEntry.variable
            ? []
            : {
                ...contextEntry,
                variable: contextEntry.variable,
                index: i,
            });
    }, [contextExpression.contextEntry]);
    return (_jsx(NestedExpressionContainerContext.Provider, { value: nestedExpressionContainerValue, children: _jsx("div", { className: `context-expression ${id}`, children: _jsx(BeeTable, { isReadOnly: isReadOnly, isEditableHeader: !isReadOnly, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: id, headerLevelCountForAppendingRowIndexColumn: 1, headerVisibility: headerVisibility, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: beeTableColumns, rows: beeTableRows, onColumnUpdates: onColumnUpdates, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, getRowKey: getRowKey, additionalRow: beeTableAdditionalRow, onRowAdded: onRowAdded, onRowReset: onRowReset, onRowDeleted: onRowDeleted, onColumnResizingWidthChange: onColumnResizingWidthChange, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: false }) }) }));
}
export function solveResultAndEntriesIndex({ contextEntries, rowIndex, }) {
    const resultIndex = contextEntries.findIndex((e) => !e.variable);
    const hasResultEntry = resultIndex > -1;
    const isResultOperation = rowIndex === Math.max(1, hasResultEntry ? contextEntries.length - 1 : contextEntries.length);
    const entryIndex = Math.min(contextEntries.length - 1, resultIndex === -1
        ? rowIndex
        : resultIndex < rowIndex
            ? rowIndex + 1
            : rowIndex);
    return { isResultOperation, hasResultEntry, resultIndex, entryIndex };
}
export function ContextResultInfoCell(props) {
    var _a, _b;
    const { containerCellCoordinates } = useBeeTableCoordinates();
    const value = useMemo(() => {
        return `<result>`;
    }, []);
    const getValue = useCallback(() => {
        return value;
    }, [value]);
    const { isActive } = useBeeTableSelectableCellRef((_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _a !== void 0 ? _a : 0, (_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _b !== void 0 ? _b : 0, undefined, getValue);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(props.parentElementId);
        }
    }, [beeGwtService, isActive, props.parentElementId]);
    return _jsx("div", { className: "context-result", children: value });
}
//# sourceMappingURL=ContextExpression.js.map