import { jsx as _jsx } from "react/jsx-runtime";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { useCallback } from "react";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
export function ConditionalExpressionCell({ data, rowIndex, columnIndex, parentElementId, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                if (rowIndex === 0) {
                    const ret = {
                        ...prev,
                        if: { ...prev.if, expression: getNewExpression(prev.if.expression) },
                    };
                    return ret;
                }
                else if (rowIndex === 1) {
                    const ret = {
                        ...prev,
                        then: { ...prev.then, expression: getNewExpression(prev.then.expression) },
                    };
                    return ret;
                }
                else if (rowIndex === 2) {
                    const ret = {
                        ...prev,
                        else: { ...prev.else, expression: getNewExpression(prev.else.expression) },
                    };
                    return ret;
                }
                else {
                    throw new Error("ConditionalExpression shouldn't have more than 3 rows.");
                }
            },
            expressionChangedArgs,
        });
    }, [rowIndex, setExpression]);
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: data[rowIndex].part.expression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined }) }));
}
//# sourceMappingURL=ConditionalExpressionCell.js.map