import { jsx as _jsx } from "react/jsx-runtime";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { useCallback, useMemo, useRef } from "react";
import { NavigationKeysUtils } from "../keysUtils/keyUtils";
import "./FeelInputTextbox.css";
import { FeelInput } from "@kie-tools/feel-input-component";
export function FeelInputTextbox({ value, onChange, expressionId }) {
    const feelInputRef = useRef(null);
    const MONACO_OPTIONS = {
        fixedOverflowWidgets: true,
        lineNumbers: "off",
        fontSize: 13,
        renderLineHighlight: "none",
        lineDecorationsWidth: 1,
        automaticLayout: true,
        "semanticHighlighting.enabled": true,
    };
    const { onRequestFeelIdentifiers } = useBoxedExpressionEditor();
    const feelIdentifiers = useMemo(() => {
        return onRequestFeelIdentifiers === null || onRequestFeelIdentifiers === void 0 ? void 0 : onRequestFeelIdentifiers();
    }, [onRequestFeelIdentifiers]);
    const updateValue = useCallback((newValue) => {
        if (value !== newValue) {
            onChange(newValue);
        }
    }, [value, onChange]);
    const onFeelKeyDown = useCallback((e, newValue) => {
        var _a, _b, _c, _d;
        const eventKey = (_a = e === null || e === void 0 ? void 0 : e.code) !== null && _a !== void 0 ? _a : "";
        if (NavigationKeysUtils.isTab(eventKey) || NavigationKeysUtils.isEnter(eventKey)) {
            if ((_b = feelInputRef.current) === null || _b === void 0 ? void 0 : _b.isSuggestionWidgetOpen()) {
            }
            else {
                updateValue(newValue);
                e.preventDefault();
            }
        }
        if (NavigationKeysUtils.isEsc(eventKey)) {
            if ((_c = feelInputRef.current) === null || _c === void 0 ? void 0 : _c.isSuggestionWidgetOpen()) {
            }
            else {
                (_d = feelInputRef.current) === null || _d === void 0 ? void 0 : _d.setMonacoValue(value);
                updateValue(value);
            }
        }
    }, [updateValue, value]);
    const onFeelBlur = useCallback((valueOnBlur) => {
        updateValue(valueOnBlur);
    }, [updateValue]);
    return (_jsx("div", { className: "form-control pf-c-form-control feel-input-textbox", children: _jsx(FeelInput, { ref: feelInputRef, enabled: true, value: value, onKeyDown: onFeelKeyDown, options: MONACO_OPTIONS, onBlur: onFeelBlur, feelIdentifiers: feelIdentifiers, expressionId: expressionId }) }));
}
//# sourceMappingURL=FeelInputTextbox.js.map