import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { MenuItem } from "@patternfly/react-core/dist/js/components/Menu/MenuItem";
import { MenuItemAction } from "@patternfly/react-core/dist/js/components/Menu/MenuItemAction";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import "./MenuWithHelp.css";
export function MenuItemWithHelp({ menuItemKey, menuItemCustomText, menuItemHelp, menuItemIcon, menuItemIconStyle, setVisibleHelp, visibleHelp, }) {
    const [isHovered, setIsHovered] = React.useState();
    return (_jsx(MenuItem, { className: "menu-item-with-help", onMouseEnter: () => setIsHovered(true), onMouseLeave: () => setIsHovered(false), actions: (isHovered || visibleHelp === menuItemHelp) && (_jsx(MenuItemAction, { onClick: (e) => {
                e.stopPropagation();
                setVisibleHelp(menuItemHelp);
            }, icon: _jsx(HelpIcon, { "aria-hidden": true }), actionId: menuItemKey + "-help", "aria-label": menuItemKey + "-help" })), description: visibleHelp === menuItemHelp ? menuItemHelp : "", itemId: menuItemKey, icon: menuItemIcon && (_jsx("div", { style: menuItemIconStyle !== null && menuItemIconStyle !== void 0 ? menuItemIconStyle : undefined, children: _jsx(_Fragment, { children: menuItemIcon }) })), children: menuItemCustomText !== null && menuItemCustomText !== void 0 ? menuItemCustomText : menuItemKey }, menuItemKey));
}
//# sourceMappingURL=MenuItemWithHelp.js.map