export type ExpressionChangedArgs = ({
    action: Action.ExpressionReset | Action.ExpressionCreated | Action.ExpressionPastedFromClipboard | Action.DecisionTableCellsUpdated | Action.DecisionTableHitPolicyChanged | Action.DecisionTableBuiltInAggregatorChanged | Action.FunctionParameterAdded | Action.FunctionParameterTypeChanged | Action.FunctionParameterRemoved | Action.IteratorVariableDefined | Action.RelationCellsUpdated | Action.InvocationParametersChanged | Action.ColumnChanged;
} & {}) | ({
    action: Action.RowsAdded;
} & RowsAddedArgs) | ({
    action: Action.RowDuplicated;
} & RowDuplicatedArgs) | ({
    action: Action.ColumnAdded;
} & ColumnsAddedArgs) | ({
    action: Action.RowRemoved;
} & RowRemovedArgs) | ({
    action: Action.RowReset;
} & RowResetArgs) | ({
    action: Action.ColumnRemoved;
} & ColumnRemovedArgs) | ({
    action: Action.LiteralTextExpressionChanged;
} & LiteralTextExpressionChangedArgs) | ({
    action: Action.FunctionKindChanged;
} & FunctionKindChangedArgs) | ({
    action: Action.VariableChanged;
} & VariableChangedArgs);
export type VariableChangedProperty = {
    from: string | undefined;
    to: string | undefined;
};
export type VariableChangedArgs = {
    typeChange?: VariableChangedProperty | undefined;
    nameChange?: VariableChangedProperty | undefined;
    variableUuid: string;
};
export interface ColumnsAddedArgs {
    columnIndex: number;
    columnCount: number;
}
export interface RowsAddedArgs {
    rowIndex: number;
    rowsCount: number;
}
export interface RowDuplicatedArgs {
    rowIndex: number;
}
export interface RowRemovedArgs {
    rowIndex: number;
}
export interface RowResetArgs {
    rowIndex: number;
}
export interface ColumnRemovedArgs {
    columnIndex: number;
}
export interface LiteralTextExpressionChangedArgs {
    from: string;
    to: string;
}
export interface FunctionKindChangedArgs {
    from: string;
    to: string;
}
export declare enum Action {
    ExpressionReset = 0,
    ExpressionCreated = 1,
    ExpressionPastedFromClipboard = 2,
    RowsAdded = 3,
    RowRemoved = 4,
    RowReset = 5,
    RowDuplicated = 6,
    ColumnAdded = 7,
    ColumnRemoved = 8,
    ColumnChanged = 9,
    VariableChanged = 10,
    LiteralTextExpressionChanged = 11,
    DecisionTableCellsUpdated = 12,
    DecisionTableHitPolicyChanged = 13,
    DecisionTableBuiltInAggregatorChanged = 14,
    FunctionKindChanged = 15,
    FunctionParameterAdded = 16,
    FunctionParameterTypeChanged = 17,
    FunctionParameterRemoved = 18,
    RelationCellsUpdated = 19,
    InvocationParametersChanged = 20,
    IteratorVariableDefined = 21
}
//# sourceMappingURL=ExpressionChange.d.ts.map