import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { OperatingSystem } from "@kie-tools-core/operating-system";
import { FileLanguage, SwfLanguageServiceCommandIds } from "@kie-tools/serverless-workflow-language-service/dist/api";
import { editor, Position } from "monaco-editor";
export interface SwfTextEditorApi {
    editor: editor.IStandaloneCodeEditor | undefined;
    show: (container: HTMLDivElement, theme?: EditorTheme) => editor.IStandaloneCodeEditor;
    undo: () => void;
    redo: () => void;
    getContent: () => string;
    setTheme: (theme: EditorTheme) => void;
    forceRedraw: () => void;
    dispose: () => void;
    moveCursorToNode: (nodeName: string) => void;
    moveCursorToPosition: (position: Position) => void;
}
export declare enum SwfTextEditorOperation {
    UNDO = 0,
    REDO = 1,
    EDIT = 2
}
export interface SwfTextEditorInstance {
    commands: SwfLanguageServiceCommandIds;
    instance: editor.IStandaloneCodeEditor;
}
export declare class SwfTextEditorController implements SwfTextEditorApi {
    private readonly onContentChange;
    private readonly language;
    private readonly operatingSystem;
    private readonly isReadOnly;
    private readonly setValidationErrors;
    private readonly onSelectionChanged;
    private readonly model;
    editor: editor.IStandaloneCodeEditor | undefined;
    constructor(content: string, onContentChange: (args: {
        content: string;
        operation: SwfTextEditorOperation;
    }) => void, language: FileLanguage, operatingSystem: OperatingSystem | undefined, isReadOnly: boolean, setValidationErrors: (errors: editor.IMarker[]) => void, onSelectionChanged: (nodeName: string) => void);
    redo(): void;
    undo(): void;
    getValidationMarkers: () => editor.IMarker[];
    setTheme(theme: EditorTheme): void;
    show(container: HTMLDivElement, theme: EditorTheme): editor.IStandaloneCodeEditor;
    getContent(): string;
    forceRedraw(): void;
    moveCursorToNode(nodeName: string): void;
    moveCursorToPosition(position: Position): void;
    handleDidChangeCursorSelection(event: editor.ICursorSelectionChangedEvent): void;
    private getMonacoThemeByEditorTheme;
    dispose(): void;
}
//# sourceMappingURL=SwfTextEditorController.d.ts.map