"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwfTextEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = require("react");
var react_1 = require("react");
var SwfTextEditorController_1 = require("./SwfTextEditorController");
var completion_1 = require("./augmentation/completion");
var codeLenses_1 = require("./augmentation/codeLenses");
var commands_1 = require("./augmentation/commands");
var api_1 = require("@kie-tools-core/editor/dist/api");
var hooks_1 = require("@kie-tools-core/envelope-bus/dist/hooks");
var api_2 = require("@kie-tools/serverless-workflow-language-service/dist/api");
var RefForwardingSwfTextEditor = function (_a, forwardedRef) {
    var _b, _c, _d;
    var content = _a.content, fileName = _a.fileName, onContentChange = _a.onContentChange, channelType = _a.channelType, isReadOnly = _a.isReadOnly, setValidationErrors = _a.setValidationErrors;
    var container = (0, react_1.useRef)(null);
    var editorEnvelopeCtx = (0, api_1.useKogitoEditorEnvelopeContext)();
    var _e = __read((0, hooks_1.useSharedValue)((_b = editorEnvelopeCtx.channelApi) === null || _b === void 0 ? void 0 : _b.shared.kogitoEditor_theme), 1), theme = _e[0];
    var _f = __read((0, hooks_1.useSharedValue)((_c = editorEnvelopeCtx.channelApi) === null || _c === void 0 ? void 0 : _c.shared.kogitoSwfServiceCatalog_services), 1), services = _f[0];
    var _g = __read((0, hooks_1.useSharedValue)((_d = editorEnvelopeCtx.channelApi) === null || _d === void 0 ? void 0 : _d.shared.kogitoSwfServiceCatalog_serviceRegistriesSettings), 1), serviceRegistriesSettings = _g[0];
    var fileLanguage = (0, react_1.useMemo)(function () { return (0, api_2.getFileLanguage)(fileName); }, [fileName]);
    var onSelectionChanged = (0, react_1.useCallback)(function (nodeName) {
        editorEnvelopeCtx.channelApi.notifications.kogitoSwfTextEditor__onSelectionChanged.send({ nodeName: nodeName });
    }, [editorEnvelopeCtx]);
    var controller = (0, react_1.useMemo)(function () {
        if (fileLanguage !== null) {
            return new SwfTextEditorController_1.SwfTextEditorController(content, onContentChange, fileLanguage, editorEnvelopeCtx.operatingSystem, isReadOnly, setValidationErrors, onSelectionChanged);
        }
        throw new Error("Unsupported extension '".concat(fileName, "'"));
    }, [
        fileLanguage,
        fileName,
        content,
        onContentChange,
        editorEnvelopeCtx.operatingSystem,
        isReadOnly,
        setValidationErrors,
        onSelectionChanged,
    ]);
    (0, react_1.useEffect)(function () {
        controller.forceRedraw();
    }, [services, serviceRegistriesSettings, controller]);
    (0, react_1.useEffect)(function () {
        if (!container.current) {
            return;
        }
        if (editorEnvelopeCtx.channelApi && theme === undefined) {
            return;
        }
        setBackgroundColor(theme, container.current);
        var instance = controller.show(container.current, theme !== null && theme !== void 0 ? theme : api_1.EditorTheme.LIGHT);
        var commands = (0, commands_1.initAugmentationCommands)(instance, editorEnvelopeCtx.channelApi);
        var completion = (0, completion_1.initCompletion)(commands, editorEnvelopeCtx.channelApi);
        var codeLenses = (0, codeLenses_1.initJsonCodeLenses)(commands, editorEnvelopeCtx.channelApi, isReadOnly);
        return function () {
            controller.dispose();
            codeLenses.dispose();
            completion.dispose();
        };
    }, [
        content,
        fileName,
        channelType,
        controller,
        theme,
        editorEnvelopeCtx.channelApi,
        editorEnvelopeCtx.operatingSystem,
        isReadOnly,
    ]);
    (0, react_1.useImperativeHandle)(forwardedRef, function () { return controller; }, [controller]);
    return (0, jsx_runtime_1.jsx)("div", { style: { height: "100%" }, ref: container });
};
function setBackgroundColor(theme, element) {
    switch (theme) {
        case api_1.EditorTheme.DARK: {
            element.style.background = "#000";
            break;
        }
        default: {
            element.style.background = "#fff";
            break;
        }
    }
}
exports.SwfTextEditor = React.forwardRef(RefForwardingSwfTextEditor);
//# sourceMappingURL=SwfTextEditor.js.map