import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { TaskInboxEnvelopeView } from "./TaskInboxEnvelopeView";
import { TaskInboxEnvelopeApiImpl } from "./TaskInboxEnvelopeApiImpl";
import { Envelope } from "@kie-tools-core/envelope";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            ReactDOM.render(_jsx(TaskInboxEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new TaskInboxEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=TaskInboxEnvelope.js.map