const CLAIM_PHASE = "claim";
const REASSIGN_PHASE = "reassign";
const FAIL_PHASE = "fail";
const BANNED_PHASES = [REASSIGN_PHASE, FAIL_PHASE];
export function filterTaskPhases(phases) {
    if (!phases) {
        return [];
    }
    if (phases.some((phase) => phase.toLowerCase() === CLAIM_PHASE)) {
        return [CLAIM_PHASE];
    }
    return phases.filter((phase) => !BANNED_PHASES.includes(phase.toLowerCase()));
}
//# sourceMappingURL=TaskPhasesUtils.js.map