import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { TaskDetailsEnvelopeView } from "./TaskDetailsEnvelopeView";
import { TaskDetailsEnvelopeApiImpl } from "./TaskDetailsEnvelopeApiImpl";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            ReactDOM.render(_jsx(TaskDetailsEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => {
            return new TaskDetailsEnvelopeApiImpl(apiFactoryArgs);
        },
    });
}
//# sourceMappingURL=TaskDetailsEnvelope.js.map