import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import ProcessDetails from "./components/ProcessDetails/ProcessDetails";
import ProcessDetailsEnvelopeViewDriver from "./ProcessDetailsEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const ProcessDetailsEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [processInstance, setProcessInstance] = useState({});
    const [omittedProcessTimelineEvents, setOmittedProcessTimelineEvents] = useState([]);
    const [diagramPreviewSize, setDiagramPreviewSize] = useState();
    const [showSwfDiagram, setShowSwfDiagram] = useState(false);
    const [singularProcessLabel, setSingularProcessLabel] = useState("");
    const [pluralProcessLabel, setPluralProcessLabel] = useState("");
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setProcessInstance(initArgs.processInstance);
            setOmittedProcessTimelineEvents(initArgs.omittedProcessTimelineEvents);
            setDiagramPreviewSize(initArgs.diagramPreviewSize);
            setSingularProcessLabel(initArgs.singularProcessLabel);
            setPluralProcessLabel(initArgs.pluralProcessLabel);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(ProcessDetails, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new ProcessDetailsEnvelopeViewDriver(props.channelApi), processDetails: processInstance, omittedProcessTimelineEvents: omittedProcessTimelineEvents, diagramPreviewSize: diagramPreviewSize, showSwfDiagram: showSwfDiagram, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel }) }));
});
export default ProcessDetailsEnvelopeView;
//# sourceMappingURL=ProcessDetailsEnvelopeView.js.map