import { jsx as _jsx } from "react/jsx-runtime";
import { PlayIcon } from "@patternfly/react-icons/dist/js/icons/play-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
export const getColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => _jsx("span", { children: value }),
    };
};
export const getActionColumn = (startProcess, singularProcessLabel) => {
    return {
        label: "Actions",
        path: "actions",
        bodyCellTransformer: (value, rowData) => (_jsx(Tooltip, { content: `Start new ${singularProcessLabel.toLowerCase()}`, children: _jsx(Button, { onClick: () => startProcess(rowData), variant: "link", children: _jsx(PlayIcon, {}) }) })),
    };
};
//# sourceMappingURL=ProcessDefinitionListUtils.js.map