import { ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { OpenshiftApiVersions } from "./api";
import { ResourceDataSource, commonLabels, runtimeLabels, } from "../common";
export const ROUTE_TEMPLATE = (args) => ({
    apiVersion: OpenshiftApiVersions.ROUTE,
    kind: "Route",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: {
            ...commonLabels({ ...args }),
            ...runtimeLabels(),
        },
    },
    spec: {
        to: {
            name: args.resourceName,
            kind: "Service",
        },
        port: {
            targetPort: "8080-tcp",
        },
        tls: {
            termination: "edge",
            insecureEdgeTerminationPolicy: "None",
        },
    },
});
export class CreateRoute extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : ROUTE_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.ROUTE}/namespaces/${this.args.namespace}/routes`;
    }
}
export class ListRoutes extends ResourceFetch {
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.ROUTE}/namespaces/${this.args.namespace}/routes`;
    }
}
export class DeleteRoute extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    body() {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.ROUTE}/namespaces/${this.args.namespace}/routes/${this.args.resourceName}`;
    }
}
export class GetRoute extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.GET;
    }
    endpoint() {
        return `/apis/${OpenshiftApiVersions.ROUTE}/namespaces/${this.args.namespace}/routes/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=Route.js.map