import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { IIngress } from "kubernetes-models/networking.k8s.io/v1";
import { ResourceDataSource, ResourceGroupDescriptor, ResourceMetadataEnforcer } from "../common";
export type IngressDescriptor = IIngress & ResourceMetadataEnforcer;
export type IngressGroupDescriptor = ResourceGroupDescriptor<IngressDescriptor>;
export type CreateIngressArgs = CreateResourceFetchArgs & ({
    resourceDataSource: ResourceDataSource.TEMPLATE;
} | {
    descriptor: IngressDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const INGRESS_TEMPLATE: (args: CreateResourceFetchArgs) => IngressDescriptor;
export declare class CreateIngress extends ResourceFetch {
    protected args: CreateIngressArgs;
    constructor(args: CreateIngressArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class ListIngresses extends ResourceFetch {
    method(): HttpMethod;
    endpoint(): string;
}
export declare class DeleteIngress extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    body(): string;
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=Ingress.d.ts.map