import { InternalAxiosRequestConfig } from "axios";
import Keycloak from "keycloak-js";
import { UserContext } from "../contexts/KogitoAppContext";
export interface KogitoConsolesKeycloakEnv {
    KOGITO_CONSOLES_KEYCLOAK_DISABLE_HEALTH_CHECK?: boolean;
    KOGITO_CONSOLES_KEYCLOAK_UPDATE_TOKEN_VALIDITY?: number;
    KOGITO_CONSOLES_KEYCLOAK_HEALTH_CHECK_URL?: string;
    KOGITO_CONSOLES_KEYCLOAK_REALM?: string;
    KOGITO_CONSOLES_KEYCLOAK_URL?: string;
    KOGITO_CONSOLES_KEYCLOAK_CLIENT_ID?: string;
}
export declare const isAuthEnabled: () => boolean;
export declare const isKeycloakHealthCheckDisabled: () => boolean;
export declare const getUpdateTokenValidity: () => number;
export declare const getLoadedSecurityContext: () => UserContext;
export declare const checkAuthServerHealth: () => Promise<void>;
export declare const getKeycloakClient: () => Keycloak;
export declare const initializeKeycloak: (onloadSuccess: () => void) => Promise<void>;
export declare const loadSecurityContext: (onloadSuccess: () => void, onLoadFailure: () => void) => Promise<void>;
export declare const getToken: () => string | undefined;
export declare const updateKeycloakToken: () => Promise<void>;
export declare const setBearerToken: (config: InternalAxiosRequestConfig) => Promise<InternalAxiosRequestConfig>;
export declare const appRenderWithAxiosInterceptorConfig: (appRender: (ctx: UserContext) => void, onLoadFailure: () => void) => Promise<void>;
export declare const handleLogout: () => void;
//# sourceMappingURL=KeycloakClient.d.ts.map