import { User, LogoutUserContext } from "./Auth";
export interface KeycloakInfo {
    userName: string;
    roles: string[];
    token: string;
    tokenMinValidity: number;
    logout: () => void;
}
export declare class KeycloakUserContext implements LogoutUserContext {
    private readonly currentUser;
    private token;
    private readonly tokenMinValidity;
    private handleLogout;
    constructor(keycloakInfo: KeycloakInfo);
    logout(): void;
    getCurrentUser(): User;
    getToken(): string;
    setToken(token: string): void;
    getTokenMinValidity(): number;
}
//# sourceMappingURL=KeycloakUserContext.d.ts.map