import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState, useMemo } from "react";
import { Alert, AlertActionCloseButton, AlertActionLink } from "@patternfly/react-core/dist/js/components/Alert";
import { componentOuiaProps } from "../../ouiaTools";
export const FormNotification = ({ notification, ouiaId, ouiaSafe }) => {
    const variant = notification.type === "error" ? "danger" : "success";
    const [showDetails, setShowDetails] = useState(false);
    const content = useMemo(() => showDetails && notification.details && _jsx("p", { children: notification.details }), [showDetails, notification.details]);
    return (_jsx(Alert, { isInline: true, title: notification.message, variant: variant, actionLinks: _jsxs(React.Fragment, { children: [notification.details && (_jsx(AlertActionLink, { onClick: () => setShowDetails((currentValue) => !currentValue), children: "View details" })), notification.customActions &&
                    notification.customActions.length > 0 &&
                    notification.customActions.map((customAction, index) => {
                        return (_jsx(AlertActionLink, { onClick: customAction.onClick, children: customAction.label }, index));
                    })] }), actionClose: _jsx(AlertActionCloseButton, { onClose: notification.close }), ...componentOuiaProps(ouiaId, "form-notification-alert", ouiaSafe), children: content }));
};
//# sourceMappingURL=FormNotification.js.map