"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LOGS = void 0;
var lib_1 = require("./lib");
exports.LOGS = {
    error: {
        foundConflictingVars: function () {
            return "[build-env] ERROR: Found conflicting vars.";
        },
        foundConflictingRootProps: function () {
            return "[build-env] ERROR: Found conflicting root properties.";
        },
        envNotFound: function (args) {
            return "[build-env] ERROR: Env not found at '".concat(args.envPath, "'");
        },
        envFileLoadingError: function (args) {
            return "[build-env] ERROR: Error loading env at '".concat(args.envFilePath, "'");
        },
        findEnvRecursionStopped: function (args) {
            return "[build-env] ERROR: Couldn't load env from '".concat(args.startDir, "' to '").concat(args.curDir, "'. Stopped at '").concat(args.envRecursionStopPath, "'");
        },
        cantNegateNonBoolean: function (args) {
            return "[build-env] ERROR: Cannot negate non-boolean value '".concat(args.envPropertyValue, "'");
        },
        cantReturnNonString: function (args) {
            return "[build-env] ERROR: Env property '".concat(args.propertyPath, "' is not of type \"string\", \"number\", or \"boolean\". Found \"").concat(args.propertyType, "\":");
        },
        pleaseProvideEnvPropertyPath: function () {
            return "[build-env] ERROR: Please provide an env property path.";
        },
        propertyNotFound: function (args) {
            return "[build-env] ERROR: Env property '".concat(args.propertyPath, "' not found.");
        },
        usingConfiguredAccessErrorLogFile: function (_a) {
            var logFilePath = _a.logFilePath;
            return "[build-env] ERROR: Env property access error. Using configured access errors log file '".concat(logFilePath, "'");
        },
        errorWritingAccessErrorLog: function (_a) {
            var logFilePath = _a.logFilePath;
            return "[build-env] ERROR: Error writing access error log to '".concat(logFilePath, "'. Property access errors won't be detectable.");
        },
    },
    warn: {
        defaultingAccessErrorsLogFileToTmpDirBecauseNotAbsolute: function (args) {
            return "[build-env] WARNING: Supplied path for access errors log file is not absolute ('".concat(args.suppliedPath, "'). Defaulting to '").concat(args.logFilePath, "'.");
        },
        defaultingAccessErrorsLogFileToTmpDirBecauseNotSupplied: function (args) {
            return "[build-env] WARNING: Access errors log file absolute path not supplied via env var ".concat(lib_1.ERROR_ACCESS_LOG_FILE_ABSOLUTE_PATH_ENV_VAR_NAME, ". Defaulting to '").concat(args.logFilePath, "'.");
        },
    },
    info: {
        seeAllEnvProperties: function () {
            return "[build-env] See all env properties with 'build-env --print-env-json'";
        },
        wroteAccessErrorLog: function (args) {
            return "[build-env] Wrote access error to: '".concat(args.logFilePath, "'.");
        },
    },
    debug: {
        envFound: function (args) {
            return "[build-env] DEBUG: Found env at '".concat(args.envPath, "'");
        },
    },
};
//# sourceMappingURL=console_logs.js.map