
export const root = {
    element: "definitions",
    type: "DMN13__tDefinitions" 
} as const;

export const ns = new Map<string, string>([
    ["https://www.omg.org/spec/DMN/20191111/MODEL/", ""],
    ["", "https://www.omg.org/spec/DMN/20191111/MODEL/"],
    ["https://www.omg.org/spec/DMN/20191111/DMNDI/", "dmndi:"],
    ["dmndi:", "https://www.omg.org/spec/DMN/20191111/DMNDI/"],
    ["http://www.omg.org/spec/DMN/20180521/DC/", "dc:"],
    ["dc:", "http://www.omg.org/spec/DMN/20180521/DC/"],
    ["http://www.omg.org/spec/DMN/20180521/DI/", "di:"],
    ["di:", "http://www.omg.org/spec/DMN/20180521/DI/"],
]);

export const subs = {
  "": {
    "namedElement": "DMNElement",
    "informationRequirement": "DMNElement",
    "knowledgeRequirement": "DMNElement",
    "authorityRequirement": "DMNElement",
    "functionItem": "DMNElement",
    "artifact": "DMNElement",
    "contextEntry": "DMNElement",
    "definitions": "namedElement",
    "import": "namedElement",
    "elementCollection": "namedElement",
    "drgElement": "namedElement",
    "itemDefinition": "namedElement",
    "informationItem": "namedElement",
    "decision": "drgElement",
    "invocable": "drgElement",
    "inputData": "drgElement",
    "knowledgeSource": "drgElement",
    "performanceIndicator": "businessContextElement",
    "organizationUnit": "businessContextElement",
    "businessKnowledgeModel": "invocable",
    "decisionService": "invocable",
    "literalExpression": "expression",
    "invocation": "expression",
    "decisionTable": "expression",
    "context": "expression",
    "functionDefinition": "expression",
    "relation": "expression",
    "list": "expression",
    "group": "artifact",
    "textAnnotation": "artifact",
    "association": "artifact",
  },
  "dmndi:": {
    "dmndi:DMNShape": "dmndi:DMNDiagramElement",
    "dmndi:DMNEdge": "dmndi:DMNDiagramElement",
    "dmndi:DMNStyle": "di:Style",
  },
  "dc:": {

  },
  "di:": {

  },
};

export const elements = {
  "DMNElement": "DMN13__tDMNElement",
  "namedElement": "DMN13__tNamedElement",
  "definitions": "DMN13__tDefinitions",
  "import": "DMN13__tImport",
  "elementCollection": "DMN13__tElementCollection",
  "drgElement": "DMN13__tDRGElement",
  "decision": "DMN13__tDecision",
  "businessContextElement": "DMN13__tBusinessContextElement",
  "performanceIndicator": "DMN13__tPerformanceIndicator",
  "organizationUnit": "DMN13__tOrganizationUnit",
  "invocable": "DMN13__tInvocable",
  "businessKnowledgeModel": "DMN13__tBusinessKnowledgeModel",
  "inputData": "DMN13__tInputData",
  "knowledgeSource": "DMN13__tKnowledgeSource",
  "informationRequirement": "DMN13__tInformationRequirement",
  "knowledgeRequirement": "DMN13__tKnowledgeRequirement",
  "authorityRequirement": "DMN13__tAuthorityRequirement",
  "expression": "DMN13__tExpression",
  "itemDefinition": "DMN13__tItemDefinition",
  "functionItem": "DMN13__tFunctionItem",
  "literalExpression": "DMN13__tLiteralExpression",
  "invocation": "DMN13__tInvocation",
  "informationItem": "DMN13__tInformationItem",
  "decisionTable": "DMN13__tDecisionTable",
  "artifact": "DMN13__tArtifact",
  "group": "DMN13__tGroup",
  "textAnnotation": "DMN13__tTextAnnotation",
  "association": "DMN13__tAssociation",
  "context": "DMN13__tContext",
  "contextEntry": "DMN13__tContextEntry",
  "functionDefinition": "DMN13__tFunctionDefinition",
  "relation": "DMN13__tRelation",
  "list": "DMN13__tList",
  "decisionService": "DMN13__tDecisionService",
  "dmndi:DMNDI": "DMNDI13__DMNDI",
  "dmndi:DMNDiagram": "DMNDI13__DMNDiagram",
  "dmndi:DMNDiagramElement": "DMNDI13__DiagramElement",
  "dmndi:DMNShape": "DMNDI13__DMNShape",
  "dmndi:DMNEdge": "DMNDI13__DMNEdge",
  "dmndi:DMNStyle": "DMNDI13__DMNStyle",
  "dmndi:DMNLabel": "DMNDI13__DMNLabel",
  "dmndi:DMNDecisionServiceDividerLine": "DMNDI13__DMNDecisionServiceDividerLine",
  "dc:Color": "DC__Color",
  "dc:Point": "DC__Point",
  "dc:Bounds": "DC__Bounds",
  "dc:Dimension": "DC__Dimension",
  "di:Style": "DI__Style",
};

export const meta = {
    "DMN13__tDMNElement__extensionElements": {
    },
    "DMN13__tDMNElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDMNElement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonymous type..." },
    },
    "DMN13__tNamedElement__extensionElements": {
    },
    "DMN13__tNamedElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tNamedElement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN13__tDMNElementReference": {
        "@_href": { type: "string", isArray: false, fromType: "DMN13__tDMNElementReference", xsdType: "xsd:anyURI" },
    },
    "DMN13__tDefinitions__extensionElements": {
    },
    "DMN13__tDefinitions": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDefinitions__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "xsd:anyURI" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "xsd:anyURI" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "xsd:anyURI" },
        "@_exporter": { type: "string", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "xsd:string" },
        "@_exporterVersion": { type: "string", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "xsd:string" },
        "import": { type: "DMN13__tImport", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "itemDefinition": { type: "DMN13__tItemDefinition", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "drgElement": { type: "DMN13__tDRGElement", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "artifact": { type: "DMN13__tArtifact", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "elementCollection": { type: "DMN13__tElementCollection", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "businessContextElement": { type: "DMN13__tBusinessContextElement", isArray: true, fromType: "DMN13__tDefinitions", xsdType: "// local type" },
        "dmndi:DMNDI": { type: "DMNDI13__DMNDI", isArray: false, fromType: "DMN13__tDefinitions", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMN13__tImport__extensionElements": {
    },
    "DMN13__tImport": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tImport__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
    },
    "DMN13__tElementCollection__extensionElements": {
    },
    "DMN13__tElementCollection": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tElementCollection__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "drgElement": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tElementCollection", xsdType: "// local type" },
    },
    "DMN13__tDRGElement__extensionElements": {
    },
    "DMN13__tDRGElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDRGElement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
    },
    "DMN13__tDecision__extensionElements": {
    },
    "DMN13__tDecision": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDecision__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "question": { type: "string", isArray: false, fromType: "DMN13__tDecision", xsdType: "xsd:string" },
        "allowedAnswers": { type: "string", isArray: false, fromType: "DMN13__tDecision", xsdType: "xsd:string" },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "informationRequirement": { type: "DMN13__tInformationRequirement", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN13__tKnowledgeRequirement", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "supportedObjective": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "impactedPerformanceIndicator": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "decisionMaker": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "decisionOwner": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "usingProcess": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "usingTask": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecision", xsdType: "// local type" },
        "expression": { type: "DMN13__tExpression", isArray: false, fromType: "DMN13__tDecision", xsdType: "// local type" },
    },
    "DMN13__tBusinessContextElement__extensionElements": {
    },
    "DMN13__tBusinessContextElement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tBusinessContextElement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN13__tBusinessContextElement", xsdType: "xsd:anyURI" },
    },
    "DMN13__tPerformanceIndicator__extensionElements": {
    },
    "DMN13__tPerformanceIndicator": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tPerformanceIndicator__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN13__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "impactingDecision": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tPerformanceIndicator", xsdType: "// local type" },
    },
    "DMN13__tOrganizationUnit__extensionElements": {
    },
    "DMN13__tOrganizationUnit": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tOrganizationUnit__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_URI": { type: "string", isArray: false, fromType: "DMN13__tBusinessContextElement", xsdType: "xsd:anyURI" },
        "decisionMade": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tOrganizationUnit", xsdType: "// local type" },
        "decisionOwned": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tOrganizationUnit", xsdType: "// local type" },
    },
    "DMN13__tInvocable__extensionElements": {
    },
    "DMN13__tInvocable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInvocable__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tInvocable", xsdType: "// local type" },
    },
    "DMN13__tBusinessKnowledgeModel__extensionElements": {
    },
    "DMN13__tBusinessKnowledgeModel": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tBusinessKnowledgeModel__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tInvocable", xsdType: "// local type" },
        "encapsulatedLogic": { type: "DMN13__tFunctionDefinition", isArray: false, fromType: "DMN13__tBusinessKnowledgeModel", xsdType: "// local type" },
        "knowledgeRequirement": { type: "DMN13__tKnowledgeRequirement", isArray: true, fromType: "DMN13__tBusinessKnowledgeModel", xsdType: "// local type" },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true, fromType: "DMN13__tBusinessKnowledgeModel", xsdType: "// local type" },
    },
    "DMN13__tInputData__extensionElements": {
    },
    "DMN13__tInputData": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInputData__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tInputData", xsdType: "// local type" },
    },
    "DMN13__tKnowledgeSource__extensionElements": {
    },
    "DMN13__tKnowledgeSource": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tKnowledgeSource__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN13__tKnowledgeSource", xsdType: "xsd:anyURI" },
        "authorityRequirement": { type: "DMN13__tAuthorityRequirement", isArray: true, fromType: "DMN13__tKnowledgeSource", xsdType: "// local type" },
        "type": { type: "string", isArray: false, fromType: "DMN13__tKnowledgeSource", xsdType: "xsd:string" },
        "owner": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tKnowledgeSource", xsdType: "// local type" },
    },
    "DMN13__tInformationRequirement__extensionElements": {
    },
    "DMN13__tInformationRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInformationRequirement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tInformationRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tInformationRequirement", xsdType: "// local type" },
    },
    "DMN13__tKnowledgeRequirement__extensionElements": {
    },
    "DMN13__tKnowledgeRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tKnowledgeRequirement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "requiredKnowledge": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tKnowledgeRequirement", xsdType: "// local type" },
    },
    "DMN13__tAuthorityRequirement__extensionElements": {
    },
    "DMN13__tAuthorityRequirement": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tAuthorityRequirement__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "requiredDecision": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tAuthorityRequirement", xsdType: "// local type" },
        "requiredInput": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tAuthorityRequirement", xsdType: "// local type" },
        "requiredAuthority": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tAuthorityRequirement", xsdType: "// local type" },
    },
    "DMN13__tExpression__extensionElements": {
    },
    "DMN13__tExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tExpression__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
    },
    "DMN13__tItemDefinition__extensionElements": {
    },
    "DMN13__tItemDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tItemDefinition__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_typeLanguage": { type: "string", isArray: false, fromType: "DMN13__tItemDefinition", xsdType: "xsd:anyURI" },
        "@_isCollection": { type: "boolean", isArray: false, fromType: "DMN13__tItemDefinition", xsdType: "xsd:boolean" },
        "itemComponent": { type: "DMN13__tItemDefinition", isArray: true, fromType: "DMN13__tItemDefinition", xsdType: "// local type" },
        "functionItem": { type: "DMN13__tFunctionItem", isArray: false, fromType: "DMN13__tItemDefinition", xsdType: "// local type" },
        "typeRef": { type: "string", isArray: false, fromType: "DMN13__tItemDefinition", xsdType: "xsd:string" },
        "allowedValues": { type: "DMN13__tUnaryTests", isArray: false, fromType: "DMN13__tItemDefinition", xsdType: "// local type" },
    },
    "DMN13__tFunctionItem__extensionElements": {
    },
    "DMN13__tFunctionItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tFunctionItem__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_outputTypeRef": { type: "string", isArray: false, fromType: "DMN13__tFunctionItem", xsdType: "xsd:string" },
        "parameters": { type: "DMN13__tInformationItem", isArray: true, fromType: "DMN13__tFunctionItem", xsdType: "// local type" },
    },
    "DMN13__tLiteralExpression__extensionElements": {
    },
    "DMN13__tLiteralExpression": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tLiteralExpression__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN13__tLiteralExpression", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN13__tLiteralExpression", xsdType: "xsd:string" },
        "importedValues": { type: "DMN13__tImportedValues", isArray: false, fromType: "DMN13__tLiteralExpression", xsdType: "// local type" },
    },
    "DMN13__tInvocation__extensionElements": {
    },
    "DMN13__tInvocation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInvocation__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN13__tExpression", isArray: false, fromType: "DMN13__tInvocation", xsdType: "// local type" },
        "binding": { type: "DMN13__tBinding", isArray: true, fromType: "DMN13__tInvocation", xsdType: "// local type" },
    },
    "DMN13__tBinding": {
        "parameter": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tBinding", xsdType: "// local type" },
        "expression": { type: "DMN13__tExpression", isArray: false, fromType: "DMN13__tBinding", xsdType: "// local type" },
    },
    "DMN13__tInformationItem__extensionElements": {
    },
    "DMN13__tInformationItem": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInformationItem__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tInformationItem", xsdType: "xsd:string" },
    },
    "DMN13__tDecisionTable__extensionElements": {
    },
    "DMN13__tDecisionTable": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDecisionTable__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "@_hitPolicy": { type: "DMN13__tHitPolicy", isArray: false, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "@_aggregation": { type: "DMN13__tBuiltinAggregator", isArray: false, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "@_preferredOrientation": { type: "DMN13__tDecisionTableOrientation", isArray: false, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "@_outputLabel": { type: "string", isArray: false, fromType: "DMN13__tDecisionTable", xsdType: "xsd:string" },
        "input": { type: "DMN13__tInputClause", isArray: true, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "output": { type: "DMN13__tOutputClause", isArray: true, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "annotation": { type: "DMN13__tRuleAnnotationClause", isArray: true, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
        "rule": { type: "DMN13__tDecisionRule", isArray: true, fromType: "DMN13__tDecisionTable", xsdType: "// local type" },
    },
    "DMN13__tInputClause__extensionElements": {
    },
    "DMN13__tInputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tInputClause__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "inputExpression": { type: "DMN13__tLiteralExpression", isArray: false, fromType: "DMN13__tInputClause", xsdType: "// local type" },
        "inputValues": { type: "DMN13__tUnaryTests", isArray: false, fromType: "DMN13__tInputClause", xsdType: "// local type" },
    },
    "DMN13__tOutputClause__extensionElements": {
    },
    "DMN13__tOutputClause": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tOutputClause__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tOutputClause", xsdType: "xsd:string" },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tOutputClause", xsdType: "xsd:string" },
        "outputValues": { type: "DMN13__tUnaryTests", isArray: false, fromType: "DMN13__tOutputClause", xsdType: "// local type" },
        "defaultOutputEntry": { type: "DMN13__tLiteralExpression", isArray: false, fromType: "DMN13__tOutputClause", xsdType: "// local type" },
    },
    "DMN13__tRuleAnnotationClause": {
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tRuleAnnotationClause", xsdType: "xsd:string" },
    },
    "DMN13__tDecisionRule__extensionElements": {
    },
    "DMN13__tDecisionRule": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDecisionRule__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "inputEntry": { type: "DMN13__tUnaryTests", isArray: true, fromType: "DMN13__tDecisionRule", xsdType: "// local type" },
        "outputEntry": { type: "DMN13__tLiteralExpression", isArray: true, fromType: "DMN13__tDecisionRule", xsdType: "// local type" },
        "annotationEntry": { type: "DMN13__tRuleAnnotation", isArray: true, fromType: "DMN13__tDecisionRule", xsdType: "// local type" },
    },
    "DMN13__tRuleAnnotation": {
        "text": { type: "string", isArray: false, fromType: "DMN13__tRuleAnnotation", xsdType: "xsd:string" },
    },
    "DMN13__tImportedValues__extensionElements": {
    },
    "DMN13__tImportedValues": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tImportedValues__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "@_namespace": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
        "@_locationURI": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
        "@_importType": { type: "string", isArray: false, fromType: "DMN13__tImport", xsdType: "xsd:anyURI" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN13__tImportedValues", xsdType: "xsd:anyURI" },
        "importedElement": { type: "string", isArray: false, fromType: "DMN13__tImportedValues", xsdType: "xsd:string" },
    },
    "DMN13__tArtifact__extensionElements": {
    },
    "DMN13__tArtifact": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tArtifact__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
    },
    "DMN13__tGroup__extensionElements": {
    },
    "DMN13__tGroup": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tGroup__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tGroup", xsdType: "xsd:string" },
    },
    "DMN13__tTextAnnotation__extensionElements": {
    },
    "DMN13__tTextAnnotation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tTextAnnotation__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_textFormat": { type: "string", isArray: false, fromType: "DMN13__tTextAnnotation", xsdType: "xsd:string" },
        "text": { type: "string", isArray: false, fromType: "DMN13__tTextAnnotation", xsdType: "xsd:string" },
    },
    "DMN13__tAssociation__extensionElements": {
    },
    "DMN13__tAssociation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tAssociation__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_associationDirection": { type: "DMN13__tAssociationDirection", isArray: false, fromType: "DMN13__tAssociation", xsdType: "// local type" },
        "sourceRef": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tAssociation", xsdType: "// local type" },
        "targetRef": { type: "DMN13__tDMNElementReference", isArray: false, fromType: "DMN13__tAssociation", xsdType: "// local type" },
    },
    "DMN13__tContext__extensionElements": {
    },
    "DMN13__tContext": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tContext__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "contextEntry": { type: "DMN13__tContextEntry", isArray: true, fromType: "DMN13__tContext", xsdType: "// local type" },
    },
    "DMN13__tContextEntry__extensionElements": {
    },
    "DMN13__tContextEntry": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tContextEntry__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tContextEntry", xsdType: "// local type" },
        "expression": { type: "DMN13__tExpression", isArray: false, fromType: "DMN13__tContextEntry", xsdType: "// local type" },
    },
    "DMN13__tFunctionDefinition__extensionElements": {
    },
    "DMN13__tFunctionDefinition": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tFunctionDefinition__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "@_kind": { type: "DMN13__tFunctionKind", isArray: false, fromType: "DMN13__tFunctionDefinition", xsdType: "// local type" },
        "formalParameter": { type: "DMN13__tInformationItem", isArray: true, fromType: "DMN13__tFunctionDefinition", xsdType: "// local type" },
        "expression": { type: "DMN13__tExpression", isArray: false, fromType: "DMN13__tFunctionDefinition", xsdType: "// local type" },
    },
    "DMN13__tRelation__extensionElements": {
    },
    "DMN13__tRelation": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tRelation__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "column": { type: "DMN13__tInformationItem", isArray: true, fromType: "DMN13__tRelation", xsdType: "// local type" },
        "row": { type: "DMN13__tList", isArray: true, fromType: "DMN13__tRelation", xsdType: "// local type" },
    },
    "DMN13__tList__extensionElements": {
    },
    "DMN13__tList": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tList__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "expression": { type: "DMN13__tExpression", isArray: true, fromType: "DMN13__tList", xsdType: "// local type" },
    },
    "DMN13__tUnaryTests__extensionElements": {
    },
    "DMN13__tUnaryTests": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tUnaryTests__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_typeRef": { type: "string", isArray: false, fromType: "DMN13__tExpression", xsdType: "xsd:string" },
        "@_expressionLanguage": { type: "string", isArray: false, fromType: "DMN13__tUnaryTests", xsdType: "xsd:anyURI" },
        "text": { type: "string", isArray: false, fromType: "DMN13__tUnaryTests", xsdType: "xsd:string" },
    },
    "DMN13__tDecisionService__extensionElements": {
    },
    "DMN13__tDecisionService": {
        "@_id": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:ID" },
        "@_label": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "description": { type: "string", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "xsd:string" },
        "extensionElements": { type: "DMN13__tDecisionService__extensionElements", isArray: false, fromType: "DMN13__tDMNElement", xsdType: "Anonumous type..." },
        "@_name": { type: "string", isArray: false, fromType: "DMN13__tNamedElement", xsdType: "xsd:string" },
        "variable": { type: "DMN13__tInformationItem", isArray: false, fromType: "DMN13__tInvocable", xsdType: "// local type" },
        "outputDecision": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecisionService", xsdType: "// local type" },
        "encapsulatedDecision": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecisionService", xsdType: "// local type" },
        "inputDecision": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecisionService", xsdType: "// local type" },
        "inputData": { type: "DMN13__tDMNElementReference", isArray: true, fromType: "DMN13__tDecisionService", xsdType: "// local type" },
    },
    "DMNDI13__DMNDI": {
        "dmndi:DMNDiagram": { type: "DMNDI13__DMNDiagram", isArray: true, fromType: "DMNDI13__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNStyle": { type: "DMNDI13__DMNStyle", isArray: true, fromType: "DMNDI13__DMNDI", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNDiagram__extension": {
    },
    "DMNDI13__DMNDiagram": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNDiagram__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "@_name": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_documentation": { type: "string", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:string" },
        "@_resolution": { type: "float", isArray: false, fromType: "DI__Diagram", xsdType: "xsd:double" },
        "dmndi:Size": { type: "DC__Dimension", isArray: false, fromType: "DMNDI13__DMNDiagram", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:DMNDiagramElement": { type: "DI__DiagramElement", isArray: true, fromType: "DMNDI13__DMNDiagram", xsdType: "type found from namespace with declaration name 'di'." },
    },
    "DMNDI13__DMNShape__extension": {
    },
    "DMNDI13__DMNShape": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNShape__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:QName" },
        "@_isListedInputData": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:boolean" },
        "@_isCollapsed": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "xsd:boolean" },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
        "dmndi:DMNDecisionServiceDividerLine": { type: "DMNDI13__DMNDecisionServiceDividerLine", isArray: false, fromType: "DMNDI13__DMNShape", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNDecisionServiceDividerLine__extension": {
    },
    "DMNDI13__DMNDecisionServiceDividerLine": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNDecisionServiceDividerLine__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DMNDI13__DMNEdge__extension": {
    },
    "DMNDI13__DMNEdge": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNEdge__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "di:waypoint": { type: "DC__Point", isArray: true, fromType: "DI__Edge", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_dmnElementRef": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "@_sourceElement": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "@_targetElement": { type: "string", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "xsd:QName" },
        "dmndi:DMNLabel": { type: "DMNDI13__DMNLabel", isArray: false, fromType: "DMNDI13__DMNEdge", xsdType: "type found from namespace with declaration name 'dmndi'." },
    },
    "DMNDI13__DMNLabel__extension": {
    },
    "DMNDI13__DMNLabel": {
        "@_sharedStyle": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:IDREF" },
        "@_id": { type: "string", isArray: false, fromType: "DI__DiagramElement", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNLabel__extension", isArray: false, fromType: "DI__DiagramElement", xsdType: "Anonumous type..." },
        "di:Style": { type: "DI__Style", isArray: false, fromType: "DI__DiagramElement", xsdType: "type found from namespace with declaration name 'di'." },
        "dc:Bounds": { type: "DC__Bounds", isArray: false, fromType: "DI__Shape", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:Text": { type: "string", isArray: false, fromType: "DMNDI13__DMNLabel", xsdType: "xsd:string" },
    },
    "DMNDI13__DMNStyle__extension": {
    },
    "DMNDI13__DMNStyle": {
        "@_id": { type: "string", isArray: false, fromType: "DI__Style", xsdType: "xsd:ID" },
        "di:extension": { type: "DMNDI13__DMNStyle__extension", isArray: false, fromType: "DI__Style", xsdType: "Anonumous type..." },
        "@_fontFamily": { type: "string", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:string" },
        "@_fontSize": { type: "float", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:double" },
        "@_fontItalic": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontBold": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontUnderline": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_fontStrikeThrough": { type: "boolean", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "xsd:boolean" },
        "@_labelHorizontalAlignement": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "@_labelVerticalAlignment": { type: "DC__AlignmentKind", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FillColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:StrokeColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
        "dmndi:FontColor": { type: "DC__Color", isArray: false, fromType: "DMNDI13__DMNStyle", xsdType: "type found from namespace with declaration name 'dc'." },
    },
    "DC__Color": {
        "@_red": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_green": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
        "@_blue": { type: "integer", isArray: false, fromType: "DC__Color", xsdType: "xsd:int" },
    },
    "DC__Point": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Point", xsdType: "xsd:double" },
    },
    "DC__Dimension": {
        "@_width": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Dimension", xsdType: "xsd:double" },
    },
    "DC__Bounds": {
        "@_x": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_y": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_width": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
        "@_height": { type: "float", isArray: false, fromType: "DC__Bounds", xsdType: "xsd:double" },
    },
    "DI__DiagramElement__extension": {
    },
    "DI__Diagram__extension": {
    },
    "DI__Shape__extension": {
    },
    "DI__Edge__extension": {
    },
    "DI__Style__extension": {
    },
} as const;
