import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import _ from "lodash";
import { BeeTableHeaderVisibility, BeeTableOperation, InsertRowColumnsDirection, } from "@kie-tools/boxed-expression-component/dist/api/BeeTable";
import { ResizerStopBehavior } from "@kie-tools/boxed-expression-component/dist/resizing/ResizingWidthsContext";
import { StandaloneBeeTable, getColumnsAtLastLevel, } from "@kie-tools/boxed-expression-component/dist/table/BeeTable";
import { useTestScenarioEditorI18n } from "../i18n";
import { useTestScenarioEditorStore, useTestScenarioEditorStoreApi } from "../store/TestScenarioStoreContext";
import { addColumnWithEmptyInstanceAndProperty, addColumnWithEmptyProperty } from "../mutations/addColumn";
import { deleteColumn } from "../mutations/deleteColumn";
import "./TestScenarioTable.css";
import { addRow } from "../mutations/addRow";
import { deleteRow } from "../mutations/deleteRow";
import { dupliacteRow } from "../mutations/duplicateRow";
import { updateCell } from "../mutations/updateCell";
import { updateColumnWidth } from "../mutations/updateColumnWidth";
function TestScenarioTable({ tableData, scrollableParentRef, }) {
    var _a;
    let TestScenarioTableColumnHeaderGroup;
    (function (TestScenarioTableColumnHeaderGroup) {
        TestScenarioTableColumnHeaderGroup["EXPECT"] = "expect-header";
        TestScenarioTableColumnHeaderGroup["GIVEN"] = "given-header";
    })(TestScenarioTableColumnHeaderGroup || (TestScenarioTableColumnHeaderGroup = {}));
    let TestScenarioTableColumnInstanceGroup;
    (function (TestScenarioTableColumnInstanceGroup) {
        TestScenarioTableColumnInstanceGroup["EXPECT"] = "expect-instance";
        TestScenarioTableColumnInstanceGroup["GIVEN"] = "given-instance";
    })(TestScenarioTableColumnInstanceGroup || (TestScenarioTableColumnInstanceGroup = {}));
    let TestScenarioTableColumnFieldGroup;
    (function (TestScenarioTableColumnFieldGroup) {
        TestScenarioTableColumnFieldGroup["EXPECT"] = "expect";
        TestScenarioTableColumnFieldGroup["GIVEN"] = "given";
        TestScenarioTableColumnFieldGroup["OTHER"] = "other";
    })(TestScenarioTableColumnFieldGroup || (TestScenarioTableColumnFieldGroup = {}));
    const { i18n } = useTestScenarioEditorI18n();
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const settingsModel = useTestScenarioEditorStore((state) => state.scesim.model.ScenarioSimulationModel.settings);
    const testScenarioType = (_a = settingsModel.type) === null || _a === void 0 ? void 0 : _a.__$$text.toUpperCase();
    const isBackground = useMemo(() => {
        return "BackgroundData" in tableData.scesimData;
    }, [tableData]);
    const columnIndexStart = useMemo(() => {
        return isBackground ? 0 : 1;
    }, [isBackground]);
    const retrieveRowsData = useCallback((rowData) => {
        if (isBackground) {
            return rowData.BackgroundData;
        }
        else {
            return rowData.Scenario;
        }
    }, [isBackground]);
    const determineDataTypeLabel = useCallback((dataType, genericTypes) => {
        var _a;
        let dataTypeLabel = dataType;
        if (testScenarioType === "RULE") {
            dataTypeLabel = (_a = dataTypeLabel.split(".").pop()) !== null && _a !== void 0 ? _a : dataTypeLabel;
        }
        if (genericTypes.length == 1) {
            dataTypeLabel = testScenarioType === "RULE" ? `${dataTypeLabel}<${genericTypes[0]}>` : `${genericTypes[0]}[]`;
        }
        if (testScenarioType === "RULE" && genericTypes.length == 2) {
            dataTypeLabel = `${dataTypeLabel}<${genericTypes[0]},${genericTypes[1]}>`;
        }
        return !dataTypeLabel || dataTypeLabel.endsWith("Void") ? "<Undefined>" : dataTypeLabel;
    }, [testScenarioType]);
    const setColumnWidth = useCallback((inputIndex) => (newWidthAction) => {
        testScenarioEditorStoreApi.setState((state) => {
            var _a;
            const factMappings = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
            const oldWidth = (_a = factMappings[inputIndex].columnWidth) === null || _a === void 0 ? void 0 : _a.__$$text;
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(oldWidth) : newWidthAction;
            updateColumnWidth({
                factMappings: factMappings,
                columnIndex: inputIndex,
                newWidth: newWidth,
                oldWidth: oldWidth,
            });
        });
    }, [isBackground, testScenarioEditorStoreApi]);
    const generateColumnFromFactMapping = useCallback((factMapping, factMappingIndex, isDescriptionColumn) => {
        var _a, _b, _c, _d, _e, _f, _g;
        return {
            accessor: factMapping.expressionIdentifier.name.__$$text,
            dataType: isDescriptionColumn || ((_a = factMapping.factMappingValueType) === null || _a === void 0 ? void 0 : _a.__$$text) === "EXPRESSION"
                ? undefined
                : determineDataTypeLabel(factMapping.className.__$$text, (_d = (_c = (_b = factMapping.genericTypes) === null || _b === void 0 ? void 0 : _b.string) === null || _c === void 0 ? void 0 : _c.map((genericType) => genericType.__$$text)) !== null && _d !== void 0 ? _d : []),
            groupType: factMapping.expressionIdentifier.type.__$$text.toLowerCase(),
            id: factMapping.expressionIdentifier.name.__$$text,
            isRowIndexColumn: false,
            label: isDescriptionColumn ? factMapping.factAlias.__$$text : factMapping.expressionAlias.__$$text,
            minWidth: isDescriptionColumn ? 300 : 100,
            setWidth: setColumnWidth(factMappingIndex),
            width: (_f = (_e = factMapping.columnWidth) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : (isDescriptionColumn ? 300 : (_g = factMapping.columnWidth) === null || _g === void 0 ? void 0 : _g.__$$text),
        };
    }, [determineDataTypeLabel, setColumnWidth]);
    const generateInstanceSectionFromFactMapping = useCallback((factMapping, groupType) => {
        var _a;
        const instanceID = ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text;
        return {
            accessor: instanceID,
            dataType: determineDataTypeLabel(factMapping.factIdentifier.className.__$$text, []),
            groupType: groupType.toLowerCase(),
            id: instanceID,
            isRowIndexColumn: false,
            label: factMapping.factAlias.__$$text,
            columns: [],
        };
    }, [determineDataTypeLabel]);
    const tableColumns = useMemo(() => {
        var _a;
        const descriptionColumns = [];
        const givenInstances = [];
        const expectInstances = [];
        ((_a = tableData.scesimModelDescriptor.factMappings.FactMapping) !== null && _a !== void 0 ? _a : []).forEach((factMapping, index) => {
            var _a, _b, _c, _d;
            const instanceID = ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text;
            if (((_b = factMapping.expressionIdentifier.type) === null || _b === void 0 ? void 0 : _b.__$$text) === TestScenarioTableColumnFieldGroup.GIVEN.toUpperCase()) {
                const instance = givenInstances.find((instanceColumn) => instanceColumn.id === instanceID);
                if (instance) {
                    (_c = instance.columns) === null || _c === void 0 ? void 0 : _c.push(generateColumnFromFactMapping(factMapping, index));
                }
                else {
                    const newInstance = generateInstanceSectionFromFactMapping(factMapping, TestScenarioTableColumnInstanceGroup.GIVEN);
                    newInstance.columns.push(generateColumnFromFactMapping(factMapping, index));
                    givenInstances.push(newInstance);
                }
            }
            else if (factMapping.expressionIdentifier.type.__$$text === TestScenarioTableColumnFieldGroup.EXPECT.toUpperCase()) {
                const instance = expectInstances.find((instanceColumn) => instanceColumn.id === instanceID);
                if (instance) {
                    (_d = instance.columns) === null || _d === void 0 ? void 0 : _d.push(generateColumnFromFactMapping(factMapping, index));
                }
                else {
                    const newInstance = generateInstanceSectionFromFactMapping(factMapping, TestScenarioTableColumnInstanceGroup.EXPECT);
                    newInstance.columns.push(generateColumnFromFactMapping(factMapping, index));
                    expectInstances.push(newInstance);
                }
            }
            else if (factMapping.expressionIdentifier.type.__$$text === TestScenarioTableColumnFieldGroup.OTHER.toUpperCase() &&
                factMapping.expressionIdentifier.name.__$$text === "Description") {
                descriptionColumns.push(generateColumnFromFactMapping(factMapping, index, true));
            }
        });
        const givenSection = [
            {
                accessor: TestScenarioTableColumnHeaderGroup.GIVEN,
                groupType: TestScenarioTableColumnHeaderGroup.GIVEN,
                id: TestScenarioTableColumnHeaderGroup.GIVEN,
                isRowIndexColumn: false,
                label: i18n.table.given.toUpperCase(),
                columns: givenInstances,
            },
        ];
        const expectSection = expectInstances.length > 0
            ? [
                {
                    accessor: TestScenarioTableColumnHeaderGroup.EXPECT,
                    groupType: TestScenarioTableColumnHeaderGroup.EXPECT,
                    id: TestScenarioTableColumnHeaderGroup.EXPECT,
                    isRowIndexColumn: false,
                    label: i18n.table.expect.toUpperCase(),
                    columns: expectInstances,
                },
            ]
            : [];
        return {
            allColumns: [...descriptionColumns, ...givenSection, ...expectSection],
            instancesGroup: [...givenInstances, ...expectInstances],
        };
    }, [
        generateColumnFromFactMapping,
        generateInstanceSectionFromFactMapping,
        i18n,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnInstanceGroup,
        tableData.scesimModelDescriptor.factMappings.FactMapping,
    ]);
    const tableRows = useMemo(() => {
        var _a;
        return ((_a = retrieveRowsData(tableData.scesimData)) !== null && _a !== void 0 ? _a : []).map((scenario, index) => {
            var _a;
            const factMappingValues = (_a = scenario.factMappingValues.FactMappingValue) !== null && _a !== void 0 ? _a : [];
            const tableRow = getColumnsAtLastLevel(tableColumns.allColumns, 2).reduce((tableRow, column) => {
                var _a, _b, _c;
                const factMappingValue = factMappingValues.filter((fmv) => fmv.expressionIdentifier.name.__$$text === column.accessor);
                tableRow[column.accessor] = (_c = (_b = (_a = factMappingValue[0]) === null || _a === void 0 ? void 0 : _a.rawValue) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "";
                return tableRow;
            }, { id: index });
            return tableRow;
        });
    }, [retrieveRowsData, tableColumns.allColumns, tableData.scesimData]);
    const allowedOperations = useCallback((conditions) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const isHeader = ((_a = conditions.column) === null || _a === void 0 ? void 0 : _a.groupType) === TestScenarioTableColumnHeaderGroup.EXPECT ||
            ((_b = conditions.column) === null || _b === void 0 ? void 0 : _b.groupType) === TestScenarioTableColumnHeaderGroup.GIVEN;
        const isInstance = ((_c = conditions.column) === null || _c === void 0 ? void 0 : _c.groupType) === TestScenarioTableColumnInstanceGroup.EXPECT ||
            ((_d = conditions.column) === null || _d === void 0 ? void 0 : _d.groupType) === TestScenarioTableColumnInstanceGroup.GIVEN;
        const isOther = ((_e = conditions.column) === null || _e === void 0 ? void 0 : _e.groupType) === TestScenarioTableColumnFieldGroup.OTHER;
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd || isHeader) {
            return [];
        }
        const columnIndex = conditions.selection.selectionStart.columnIndex;
        const columnCanBeDeleted = !isOther &&
            columnIndex > 0 &&
            ((isBackground && ((_g = (_f = conditions.columns) === null || _f === void 0 ? void 0 : _f.length) !== null && _g !== void 0 ? _g : 0) > 1) ||
                (!isBackground && columnIndex > 0 && ((_j = (_h = conditions.columns) === null || _h === void 0 ? void 0 : _h.length) !== null && _j !== void 0 ? _j : 0) > 2));
        const columnsWithNoOperations = isBackground ? [0] : [0, 1];
        const columnOperations = (isInstance ? columnIndex in [0] : columnIndex in columnsWithNoOperations)
            ? []
            : [
                BeeTableOperation.ColumnInsertLeft,
                BeeTableOperation.ColumnInsertRight,
                BeeTableOperation.ColumnInsertN,
                ...(columnCanBeDeleted ? [BeeTableOperation.ColumnDelete] : []),
            ];
        return [
            ...(columnIndex >= 0 && conditions.selection.selectionStart.rowIndex < 0 ? columnOperations : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0 && columnIndex > 0
                ? [
                    BeeTableOperation.SelectionCopy,
                    BeeTableOperation.SelectionCut,
                    BeeTableOperation.SelectionPaste,
                    BeeTableOperation.SelectionReset,
                ]
                : []),
            ...(conditions.selection.selectionStart.rowIndex >= 0 && !isBackground
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    BeeTableOperation.RowDelete,
                    BeeTableOperation.RowReset,
                    BeeTableOperation.RowDuplicate,
                ]
                : []),
        ];
    }, [
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnInstanceGroup,
        TestScenarioTableColumnFieldGroup,
        isBackground,
    ]);
    const generateOperationConfig = useCallback((groupName) => {
        const isInstance = groupName === TestScenarioTableColumnInstanceGroup.EXPECT ||
            groupName === TestScenarioTableColumnInstanceGroup.GIVEN;
        const groupLabel = (!isInstance ? i18n.table.field : i18n.table.instance).toUpperCase();
        return [
            {
                group: groupLabel,
                items: [
                    {
                        name: isInstance ? i18n.table.insertLeftInstance : i18n.table.insertLeftField,
                        type: BeeTableOperation.ColumnInsertLeft,
                    },
                    {
                        name: isInstance ? i18n.table.insertRightInstance : i18n.table.insertRightField,
                        type: BeeTableOperation.ColumnInsertRight,
                    },
                    { name: i18n.table.insert, type: BeeTableOperation.ColumnInsertN },
                    {
                        name: isInstance ? i18n.table.deleteInstance : i18n.table.deleteField,
                        type: BeeTableOperation.ColumnDelete,
                    },
                ],
            },
            {
                group: i18n.table.simulation.singleEntry.toUpperCase(),
                items: [
                    { name: i18n.table.insertAbove, type: BeeTableOperation.RowInsertAbove },
                    { name: i18n.table.insertBelow, type: BeeTableOperation.RowInsertBelow },
                    { name: i18n.table.insert, type: BeeTableOperation.RowInsertN },
                    { name: i18n.table.delete, type: BeeTableOperation.RowDelete },
                    { name: i18n.table.duplicate, type: BeeTableOperation.RowDuplicate },
                ],
            },
            {
                group: i18n.table.selection.toUpperCase(),
                items: [
                    { name: i18n.table.copy, type: BeeTableOperation.SelectionCopy },
                    { name: i18n.table.cut, type: BeeTableOperation.SelectionCut },
                    { name: i18n.table.paste, type: BeeTableOperation.SelectionPaste },
                    { name: i18n.table.reset, type: BeeTableOperation.SelectionReset },
                ],
            },
        ];
    }, [TestScenarioTableColumnInstanceGroup, i18n]);
    const simulationOperationConfig = useMemo(() => {
        const config = {};
        config[""] = generateOperationConfig("");
        config[TestScenarioTableColumnHeaderGroup.EXPECT] = generateOperationConfig("");
        config[TestScenarioTableColumnHeaderGroup.GIVEN] = generateOperationConfig("");
        config[TestScenarioTableColumnInstanceGroup.EXPECT] = generateOperationConfig(TestScenarioTableColumnInstanceGroup.EXPECT);
        config[TestScenarioTableColumnInstanceGroup.GIVEN] = generateOperationConfig(TestScenarioTableColumnInstanceGroup.GIVEN);
        config[TestScenarioTableColumnFieldGroup.EXPECT] = generateOperationConfig(TestScenarioTableColumnFieldGroup.EXPECT);
        config[TestScenarioTableColumnFieldGroup.GIVEN] = generateOperationConfig(TestScenarioTableColumnFieldGroup.GIVEN);
        config[TestScenarioTableColumnFieldGroup.OTHER] = generateOperationConfig(TestScenarioTableColumnFieldGroup.OTHER);
        return config;
    }, [
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnInstanceGroup,
        generateOperationConfig,
    ]);
    const onCellUpdates = useCallback((cellUpdates) => {
        cellUpdates.forEach((update) => {
            testScenarioEditorStoreApi.setState((state) => {
                const factMappings = isBackground
                    ? state.scesim.model.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping
                    : state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
                const factMappingValuesTypes = isBackground
                    ? state.scesim.model.ScenarioSimulationModel.background.scesimData.BackgroundData
                    : state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
                updateCell({
                    columnIndex: update.columnIndex + columnIndexStart,
                    factMappings: factMappings,
                    factMappingValuesTypes: factMappingValuesTypes,
                    rowIndex: update.rowIndex,
                    value: update.value,
                });
            });
        });
    }, [columnIndexStart, isBackground, testScenarioEditorStoreApi]);
    const determineSelectedColumnIndex = useCallback((factMappings, originalSelectedColumnIndex, isInstance) => {
        var _a;
        if (isInstance) {
            const instanceSectionID = tableColumns.instancesGroup[originalSelectedColumnIndex - 1].id;
            return ((_a = factMappings.findIndex((factMapping) => {
                var _a;
                return ((_a = factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) + "." + factMapping.factIdentifier.name.__$$text ===
                    instanceSectionID;
            })) !== null && _a !== void 0 ? _a : -1);
        }
        return originalSelectedColumnIndex - (isBackground ? 1 : 0);
    }, [isBackground, tableColumns.instancesGroup]);
    const determineNewColumnTargetIndex = (factMappings, insertDirection, isInstance, selectedColumnIndex, selectedFactMapping) => {
        var _a, _b, _c, _d;
        const groupType = selectedFactMapping.expressionIdentifier.type.__$$text;
        const instanceName = selectedFactMapping.factIdentifier.name.__$$text;
        const instanceType = selectedFactMapping.factIdentifier.className.__$$text;
        if (!isInstance) {
            if (insertDirection === InsertRowColumnsDirection.AboveOrRight) {
                return selectedColumnIndex + 1;
            }
            else {
                return selectedColumnIndex;
            }
        }
        let newColumnTargetColumn = -1;
        if (insertDirection === InsertRowColumnsDirection.AboveOrRight) {
            for (let i = selectedColumnIndex; i < factMappings.length; i++) {
                const currentFM = factMappings[i];
                if (currentFM.expressionIdentifier.type.__$$text === groupType &&
                    ((_a = currentFM.factIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === instanceName &&
                    ((_b = currentFM.factIdentifier.className) === null || _b === void 0 ? void 0 : _b.__$$text) === instanceType) {
                    if (i == factMappings.length - 1) {
                        newColumnTargetColumn = i + 1;
                    }
                }
                else {
                    newColumnTargetColumn = i;
                    break;
                }
            }
        }
        else {
            for (let i = selectedColumnIndex; i >= 0; i--) {
                const currentFM = factMappings[i];
                if (currentFM.expressionIdentifier.type.__$$text === groupType &&
                    ((_c = currentFM.factIdentifier.name) === null || _c === void 0 ? void 0 : _c.__$$text) === instanceName &&
                    ((_d = currentFM.factIdentifier.className) === null || _d === void 0 ? void 0 : _d.__$$text) === instanceType) {
                    if (i == 0) {
                        newColumnTargetColumn = 0;
                    }
                }
                else {
                    newColumnTargetColumn = i + 1;
                    break;
                }
            }
        }
        return newColumnTargetColumn;
    };
    const onColumnAdded = useCallback((args) => {
        if (TestScenarioTableColumnFieldGroup.OTHER === args.groupType ||
            TestScenarioTableColumnHeaderGroup.EXPECT === args.groupType ||
            TestScenarioTableColumnHeaderGroup.GIVEN === args.groupType) {
            console.error("Can't add a " + args.groupType + " type column.");
            return;
        }
        const isInstance = args.groupType === TestScenarioTableColumnInstanceGroup.EXPECT ||
            args.groupType === TestScenarioTableColumnInstanceGroup.GIVEN;
        testScenarioEditorStoreApi.setState((state) => {
            var _a;
            const factMappings = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
            const factMappingValues = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimData.BackgroundData
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            const selectedColumnFactMappingIndex = determineSelectedColumnIndex(factMappings, args.currentIndex, isInstance);
            const selectedColumnFactMapping = factMappings[selectedColumnFactMappingIndex];
            const targetColumnIndex = determineNewColumnTargetIndex(factMappings, args.insertDirection, isInstance, selectedColumnFactMappingIndex, selectedColumnFactMapping);
            const isNewInstance = isInstance || ((_a = selectedColumnFactMapping.factIdentifier.className) === null || _a === void 0 ? void 0 : _a.__$$text) === "java.lang.Void";
            for (let columnIndex = 0; columnIndex < args.columnsCount; columnIndex++) {
                isNewInstance
                    ? addColumnWithEmptyInstanceAndProperty({
                        expressionIdentifierType: selectedColumnFactMapping.expressionIdentifier.type.__$$text,
                        factMappings: factMappings,
                        factMappingValuesTypes: factMappingValues,
                        targetColumnIndex: targetColumnIndex + columnIndex,
                    })
                    : addColumnWithEmptyProperty({
                        expressionElementsSteps: [
                            selectedColumnFactMapping.expressionElements.ExpressionElement[0].step.__$$text,
                        ],
                        expressionIdentifierType: selectedColumnFactMapping.expressionIdentifier.type.__$$text,
                        factAlias: selectedColumnFactMapping.factAlias.__$$text,
                        factIdentifierClassName: selectedColumnFactMapping.factIdentifier.className.__$$text,
                        factIdentifierName: selectedColumnFactMapping.factIdentifier.name.__$$text,
                        factMappings: factMappings,
                        factMappingValuesTypes: factMappingValues,
                        targetColumnIndex: targetColumnIndex + columnIndex,
                    });
            }
        });
    }, [
        determineSelectedColumnIndex,
        isBackground,
        testScenarioEditorStoreApi,
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnInstanceGroup,
    ]);
    const onColumnDeleted = useCallback((args) => {
        if (TestScenarioTableColumnFieldGroup.OTHER === args.groupType ||
            TestScenarioTableColumnHeaderGroup.EXPECT === args.groupType ||
            TestScenarioTableColumnHeaderGroup.GIVEN === args.groupType) {
            console.error("Can't delete a " + args.groupType + " type column.");
            return;
        }
        const isInstance = args.groupType === TestScenarioTableColumnInstanceGroup.EXPECT ||
            args.groupType === TestScenarioTableColumnInstanceGroup.GIVEN;
        testScenarioEditorStoreApi.setState((state) => {
            const factMappings = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
            const factMappingValues = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimData.BackgroundData
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            const factMappingIndexToRemove = determineSelectedColumnIndex(factMappings, args.columnIndex + 1, isInstance);
            const factMappingExpressionIdentifierTypeToRemove = factMappings[factMappingIndexToRemove].expressionIdentifier.type.__$$text;
            const { deletedFactMappingIndexs } = deleteColumn({
                factMappingIndexToRemove: factMappingIndexToRemove,
                factMappings: factMappings,
                factMappingValues: factMappingValues,
                isBackground: isBackground,
                isInstance: isInstance,
                selectedColumnIndex: args.columnIndex,
            });
            const factMappingGroupElementsAfterRemoval = _.groupBy(factMappings, (factMapping) => factMapping.expressionIdentifier.type.__$$text)[factMappingExpressionIdentifierTypeToRemove];
            const isAtLeastOneGroupElementPresent = !!factMappingGroupElementsAfterRemoval && factMappingGroupElementsAfterRemoval.length > 0;
            if (!isAtLeastOneGroupElementPresent) {
                addColumnWithEmptyInstanceAndProperty({
                    expressionIdentifierType: factMappingExpressionIdentifierTypeToRemove,
                    factMappings: factMappings,
                    factMappingValuesTypes: factMappingValues,
                    targetColumnIndex: Math.min(...deletedFactMappingIndexs),
                });
            }
            const firstRemovedIndex = Math.min(...deletedFactMappingIndexs);
            const selectedColumnIndex = Math.max(0, firstRemovedIndex - 1);
            state.dispatch(state).table.updateSelectedColumn({
                factMapping: _.cloneDeep(factMappings[selectedColumnIndex]),
                index: selectedColumnIndex,
                isBackground: isBackground,
            });
        });
    }, [
        determineSelectedColumnIndex,
        isBackground,
        testScenarioEditorStoreApi,
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        TestScenarioTableColumnInstanceGroup,
    ]);
    const onRowAdded = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        testScenarioEditorStoreApi.setState((state) => {
            const factMappings = state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
            const factMappingValues = state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            for (let rowIndex = 0; rowIndex < args.rowsCount; rowIndex++) {
                addRow({ beforeIndex: args.beforeIndex, factMappings: factMappings, factMappingValues: factMappingValues });
            }
        });
    }, [isBackground, testScenarioEditorStoreApi]);
    const onRowDeleted = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        testScenarioEditorStoreApi.setState((state) => {
            const factMappingValues = state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            deleteRow({ rowIndex: args.rowIndex, factMappingValues: factMappingValues });
            if (factMappingValues.length === 0) {
                const factMappings = state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
                addRow({ beforeIndex: args.rowIndex, factMappings: factMappings, factMappingValues: factMappingValues });
            }
        });
    }, [isBackground, testScenarioEditorStoreApi]);
    const onRowDuplicated = useCallback((args) => {
        if (isBackground) {
            throw new Error("Impossible state. Background table can have a single row only");
        }
        testScenarioEditorStoreApi.setState((state) => {
            const factMappingValues = state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            dupliacteRow({ rowIndex: args.rowIndex, factMappingValues: factMappingValues });
        });
    }, [isBackground, testScenarioEditorStoreApi]);
    const onDataCellClick = useCallback((_columnID) => {
        testScenarioEditorStoreApi.setState((state) => {
            state.dispatch(state).table.updateSelectedColumn(null);
        });
    }, [testScenarioEditorStoreApi]);
    const onHeaderClick = useCallback((columnKey) => {
        var _a;
        console.debug("[TestScenarioTable] columnKey: ", columnKey);
        if (columnKey == TestScenarioTableColumnHeaderGroup.EXPECT ||
            columnKey == TestScenarioTableColumnHeaderGroup.GIVEN) {
            testScenarioEditorStoreApi.setState((state) => {
                state.dispatch(state).table.updateSelectedColumn(null);
            });
            return;
        }
        const modelDescriptor = isBackground
            ? tableData.scesimModelDescriptor
            : tableData.scesimModelDescriptor;
        if (columnKey.startsWith(TestScenarioTableColumnFieldGroup.GIVEN.toUpperCase()) ||
            columnKey.toUpperCase().startsWith(TestScenarioTableColumnFieldGroup.EXPECT.toUpperCase())) {
            const selectedInstanceGroup = tableColumns.instancesGroup.find((instance) => instance.id === columnKey);
            if (((_a = selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns) === null || _a === void 0 ? void 0 : _a.length) === 1 &&
                (selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns[0].dataType) === "<Undefined>") {
                const propertyID = selectedInstanceGroup === null || selectedInstanceGroup === void 0 ? void 0 : selectedInstanceGroup.columns[0].id;
                const selectedFactMapping = modelDescriptor.factMappings.FactMapping.find((factMapping) => { var _a; return ((_a = factMapping.expressionIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === propertyID; });
                const selectedFactIndex = selectedFactMapping
                    ? modelDescriptor.factMappings.FactMapping.indexOf(selectedFactMapping)
                    : -1;
                testScenarioEditorStoreApi.setState((state) => {
                    state.dispatch(state).table.updateSelectedColumn({
                        factMapping: JSON.parse(JSON.stringify(selectedFactMapping)),
                        index: selectedFactIndex !== null && selectedFactIndex !== void 0 ? selectedFactIndex : -1,
                        isBackground: isBackground,
                    });
                });
            }
            else {
                testScenarioEditorStoreApi.setState((state) => {
                    state.dispatch(state).table.updateSelectedColumn(null);
                });
            }
            return;
        }
        const selectedFactMapping = modelDescriptor.factMappings.FactMapping.find((factMapping) => { var _a; return ((_a = factMapping.expressionIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) == columnKey; });
        const selectedFactIndex = selectedFactMapping
            ? modelDescriptor.factMappings.FactMapping.indexOf(selectedFactMapping)
            : -1;
        testScenarioEditorStoreApi.setState((state) => {
            state.dispatch(state).table.updateSelectedColumn({
                factMapping: JSON.parse(JSON.stringify(selectedFactMapping)),
                index: selectedFactIndex !== null && selectedFactIndex !== void 0 ? selectedFactIndex : -1,
                isBackground: isBackground,
            });
        });
    }, [
        TestScenarioTableColumnFieldGroup,
        TestScenarioTableColumnHeaderGroup,
        isBackground,
        tableColumns.instancesGroup,
        tableData,
        testScenarioEditorStoreApi,
    ]);
    return (_jsx("div", { className: "test-scenario-table", children: _jsx(StandaloneBeeTable, { allowedOperations: allowedOperations, columns: tableColumns.allColumns, enableKeyboardNavigation: true, headerLevelCountForAppendingRowIndexColumn: 2, headerVisibility: BeeTableHeaderVisibility.AllLevels, isEditableHeader: false, isReadOnly: false, onCellUpdates: onCellUpdates, onColumnAdded: onColumnAdded, onColumnDeleted: onColumnDeleted, onDataCellClick: onDataCellClick, onDataCellKeyUp: onDataCellClick, onHeaderClick: onHeaderClick, onHeaderKeyUp: onHeaderClick, onRowAdded: onRowAdded, onRowDeleted: onRowDeleted, onRowDuplicated: onRowDuplicated, operationConfig: simulationOperationConfig, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, rows: tableRows, scrollableParentRef: scrollableParentRef, shouldRenderRowIndexColumn: !isBackground, shouldShowColumnsInlineControls: true, shouldShowRowsInlineControls: !isBackground }) }));
}
export default TestScenarioTable;
//# sourceMappingURL=TestScenarioTable.js.map