import { createContext, useContext } from "react";
import { useStoreWithEqualityFn } from "zustand/traditional";
export const TestScenarioEditorStoreApiContext = createContext({});
export function useTestScenarioEditorStore(selector, equalityFn) {
    const store = useContext(TestScenarioEditorStoreApiContext);
    if (store === null) {
        throw new Error("Can't use Test Scenario Editor Store outside of the TestScenarioEditor component.");
    }
    return useStoreWithEqualityFn(store, selector, equalityFn);
}
export function useTestScenarioEditorStoreApi() {
    return useContext(TestScenarioEditorStoreApiContext);
}
//# sourceMappingURL=TestScenarioStoreContext.js.map