"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JqExpressionReadSchemasImpl = void 0;
var api_1 = require("@kie-tools/serverless-workflow-service-catalog/dist/api");
var channel_1 = require("@kie-tools/serverless-workflow-service-catalog/dist/channel");
var cross_fetch_1 = require("cross-fetch");
var JqExpressionReadSchemasImpl = (function () {
    function JqExpressionReadSchemasImpl() {
    }
    JqExpressionReadSchemasImpl.prototype.getContentFromRemoteUrl = function (remotePaths) {
        return __awaiter(this, void 0, void 0, function () {
            var promises, e_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        promises = remotePaths.map(function (remotePath) {
                            return new Promise(function (resolve, reject) {
                                (function () { return __awaiter(_this, void 0, void 0, function () {
                                    var response, resData, fileName, err_1;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                _a.trys.push([0, 3, , 4]);
                                                return [4, (0, cross_fetch_1.default)(remotePath)];
                                            case 1:
                                                response = _a.sent();
                                                if (response.status >= 400) {
                                                    reject("cannot fetch the data from the server: error code is ".concat(response.status));
                                                    return [2];
                                                }
                                                return [4, response.text()];
                                            case 2:
                                                resData = _a.sent();
                                                fileName = remotePath.split("/").pop();
                                                resolve({
                                                    fileName: fileName,
                                                    fileContent: Uint8Array.from(Array.from(resData).map(function (letter) { return letter.charCodeAt(0); })),
                                                    absoluteFilePath: remotePath,
                                                });
                                                return [3, 4];
                                            case 3:
                                                err_1 = _a.sent();
                                                console.error(err_1);
                                                reject(err_1);
                                                return [3, 4];
                                            case 4: return [2];
                                        }
                                    });
                                }); })();
                            });
                        });
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        return [4, Promise.all(promises)];
                    case 2: return [2, _a.sent()];
                    case 3:
                        e_1 = _a.sent();
                        console.error("failed to get content from url, reason: ", e_1);
                        return [2, []];
                    case 4: return [2];
                }
            });
        });
    };
    JqExpressionReadSchemasImpl.prototype.parseSchemaProperties = function (contentArray) {
        var _this = this;
        return contentArray.flatMap(function (content) {
            return _this.getEachProperties({
                fileName: content.fileName,
                fileContent: content.fileContent,
                absoluteFilePath: content.absoluteFilePath,
            });
        });
    };
    JqExpressionReadSchemasImpl.prototype.getEachProperties = function (args) {
        try {
            var source = {
                type: api_1.SwfCatalogSourceType === null || api_1.SwfCatalogSourceType === void 0 ? void 0 : api_1.SwfCatalogSourceType.LOCAL_FS,
                absoluteFilePath: args.absoluteFilePath,
            };
            var parsedContent = (0, channel_1.parseApiContent)({
                serviceFileName: args.fileName,
                serviceFileContent: new TextDecoder("utf-8").decode(args.fileContent),
                source: source,
            });
            return parsedContent.functions.flatMap(function (func) {
                return Object.entries(func.arguments).map(function (_a) {
                    var _b;
                    var _c = __read(_a, 2), argValue = _c[0], argType = _c[1];
                    return _b = {},
                        _b[argValue] = argType,
                        _b;
                });
            });
        }
        catch (e) {
            console.error(e);
            return [];
        }
    };
    return JqExpressionReadSchemasImpl;
}());
exports.JqExpressionReadSchemasImpl = JqExpressionReadSchemasImpl;
//# sourceMappingURL=JqExpressionReadSchemasImpl.js.map