"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateFormCode = generateFormCode;
function generateFormCode(_a) {
    var formGeneratorTheme = _a.formCodeGeneratorTheme, formSchemas = _a.formSchemas;
    return formSchemas.reduce(function (generatedForms, formSchema) {
        try {
            generatedForms.push({ formAsset: formGeneratorTheme.generate(formSchema), formError: undefined });
        }
        catch (error) {
            console.trace("Error generating form: ", error);
            generatedForms.push({ formAsset: undefined, formError: error });
        }
        return generatedForms;
    }, []);
}
//# sourceMappingURL=generateFormCode.js.map