/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;

public class IgniteThreadFactory
implements ThreadFactory {
    private final String igniteInstanceName;
    private final String threadName;
    private final AtomicInteger idxGen = new AtomicInteger();
    private final byte plc;
    private final Thread.UncaughtExceptionHandler eHnd;

    public IgniteThreadFactory(String igniteInstanceName, String threadName) {
        this(igniteInstanceName, threadName, null);
    }

    public IgniteThreadFactory(String igniteInstanceName, String threadName, Thread.UncaughtExceptionHandler eHnd) {
        this(igniteInstanceName, threadName, -1, eHnd);
    }

    public IgniteThreadFactory(String igniteInstanceName, String threadName, byte plc, Thread.UncaughtExceptionHandler eHnd) {
        this.igniteInstanceName = igniteInstanceName;
        this.threadName = threadName;
        this.plc = plc;
        this.eHnd = eHnd;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        IgniteThread thread = new IgniteThread(this.igniteInstanceName, this.threadName, r, this.idxGen.incrementAndGet(), -1, this.plc);
        if (this.eHnd != null) {
            thread.setUncaughtExceptionHandler(this.eHnd);
        }
        return thread;
    }

    public String toString() {
        return S.toString(IgniteThreadFactory.class, this, super.toString());
    }
}

