/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.maintenance;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IgniteExperimental
public interface MaintenanceRegistry {
    public boolean isMaintenanceMode();

    @Nullable
    public MaintenanceTask registerMaintenanceTask(MaintenanceTask var1) throws IgniteCheckedException;

    public boolean unregisterMaintenanceTask(String var1);

    @Nullable
    public MaintenanceTask activeMaintenanceTask(String var1);

    public void registerWorkflowCallback(@NotNull String var1, @NotNull MaintenanceWorkflowCallback var2);

    public List<MaintenanceAction<?>> actionsForMaintenanceTask(String var1);

    public void prepareAndExecuteMaintenance();

    default public void registerWorkflowCallbackIfTaskExists(@NotNull String maintenanceTaskName, @NotNull IgniteThrowableFunction<MaintenanceTask, MaintenanceWorkflowCallback> workflowCalProvider) throws IgniteCheckedException {
        MaintenanceTask task = this.activeMaintenanceTask(maintenanceTaskName);
        if (task != null) {
            this.registerWorkflowCallback(maintenanceTaskName, workflowCalProvider.apply(task));
        }
    }
}

