/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResolver;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionSingleNode;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionTable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PartitionParameterNode
extends PartitionSingleNode {
    @GridToStringExclude
    private final PartitionResolver partRslvr;
    private final int idx;
    private final int type;
    private final PartitionParameterType clientType;

    public PartitionParameterNode(PartitionTable tbl, PartitionResolver partRslvr, int idx, int type, PartitionParameterType clientType) {
        super(tbl);
        this.partRslvr = partRslvr;
        this.idx = idx;
        this.type = type;
        this.clientType = clientType;
    }

    @Override
    public Integer applySingle(PartitionClientContext cliCtx, Object ... args) throws IgniteCheckedException {
        assert (args != null);
        assert (this.idx < args.length);
        Object arg = args[this.idx];
        if (cliCtx != null) {
            return cliCtx.partition(arg, this.clientType);
        }
        assert (this.partRslvr != null);
        return this.partRslvr.partition(arg, this.type, this.tbl.cacheName());
    }

    @Override
    public boolean constant() {
        return false;
    }

    @Override
    public int value() {
        return this.idx;
    }

    public int type() {
        return this.type;
    }

    public PartitionParameterType clientType() {
        return this.clientType;
    }

    public String toString() {
        return S.toString(PartitionParameterNode.class, this);
    }
}

