/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestProtocol;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public abstract class GridRestProtocolAdapter
implements GridRestProtocol {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final GridKernalContext ctx;
    protected final IgniteLogger log;
    protected final String secretKey;
    protected InetAddress host;
    protected int port;

    protected GridRestProtocolAdapter(GridKernalContext ctx) {
        assert (ctx != null);
        assert (ctx.config().getConnectorConfiguration() != null);
        this.ctx = ctx;
        this.log = ctx.log(this.getClass());
        this.secretKey = ctx.config().getConnectorConfiguration().getSecretKey();
    }

    protected boolean authenticate(@Nullable String tok) {
        if (F.isEmpty(this.secretKey)) {
            return true;
        }
        if (F.isEmpty(tok)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(tok, ":");
        if (st.countTokens() != 2) {
            return false;
        }
        String ts = st.nextToken();
        String hash = st.nextToken();
        String s = ts + ':' + this.secretKey;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(s.getBytes(UTF_8));
            String compHash = Base64.getEncoder().encodeToString(md.digest());
            return hash.equalsIgnoreCase(compHash);
        }
        catch (NoSuchAlgorithmException e) {
            U.error(this.log, "Failed to check authentication signature.", e);
            return false;
        }
    }

    protected String startInfo() {
        return "Command protocol successfully started [name=" + this.name() + ", host=" + this.host + ", port=" + this.port + ']';
    }

    protected String stopInfo() {
        return "Command protocol successfully stopped: " + this.name();
    }

    protected final void assertParameter(boolean cond, String condDesc) throws IgniteCheckedException {
        if (!cond) {
            throw new IgniteCheckedException("REST protocol parameter failed condition check: " + condDesc);
        }
    }

    protected ConnectorConfiguration config() {
        return this.ctx.config().getConnectorConfiguration();
    }

    @Override
    public Collection<IgniteBiTuple<String, Object>> getProperties() {
        try {
            IgniteBiTuple<Collection<String>, Collection<String>> addrs = this.host != null ? U.resolveLocalAddresses(this.host) : null;
            return this.port > 0 ? Arrays.asList(F.t(this.getAddressPropertyName(), addrs.get1()), F.t(this.getHostNamePropertyName(), addrs.get2()), F.t(this.getPortPropertyName(), this.port)) : Collections.emptyList();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    protected abstract String getAddressPropertyName();

    protected abstract String getHostNamePropertyName();

    protected abstract String getPortPropertyName();

    @Override
    public void onKernalStart() {
    }

    @Override
    public void onProcessorStart() {
    }
}

